<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<script>
    $('.data_1 .input-group.date').datepicker({
        todayBtn: "linked",
        clearBtn: true,
        keyboardNavigation: false,
        forceParse: false,
        calendarWeeks: false,
        autoclose: true
    });
    var table = $('.asn-history-table').DataTable({
        responsive: true,
        scrollCollapse: false,
        scrollX: false,
        scrollY: false,
        "processing": true,
        "serverSide": true,
        "fixedHeader": true,
        "ajax": {
            "url": "/asn-history/get-data",
            "dataType": "json",
            "type": "GET",
            "data": function(result) {
                result.date_from = $('input[name="date_from"]').val();
                result.date_to = $('input[name="date_to"]').val();
                result.supplier = $('#supplier').val();
            }
        },
        "columns": [{
                "data": "id",
            },
            {
                "data": "supplier_display_name",
                "class": "supplier",
            },
            {
                "data": "filename",
                "class": "filename",
            },
            {
                "data": "date_added",
            },
            {
                "data": "download",
            },
            {
                "data": "sync",
            },
        ],
        lengthMenu: [
            [50, 100, 200, -1],
            ['50', '100', '200', 'All']
        ],
        "dom": '<"pull-left"i><"text-center"r><"pull-right"l><t><p>',
    });
    
    $('#supplier').chosen({ width: "100%" });
    $('#supplier,.date').on('change', function() {
        table.draw();
    });
    $(document).on('click','.resync', function() {
        $('#sync-success').hide();
        $('#sync-error').hide();
        let element =$(this);
        let supplier = element.data('supplier');
        let fileName = element.data('filename');
        $('.ajax-loader').show();
        $(".sync-msg").hide();
        $("#sync-success-msg").html('Manual sync started.');
        $("#sync-success").show();
        $.ajax({
            url: '/asn-history/resync-file',
            method: 'post',
            data: {
                supplier: supplier,
                file_name: fileName,
                file_path: `${supplier}/${fileName}`,
            },
            success:function(response) {
                $('.ajax-loader').hide();
                $('#sync-success').show();
                $('#sync-success-msg').text(response.message);
                $('html, body').animate({
                    scrollTop: $("#error").offset().top
                }, 3000);
            },
            error:function(xhr) {
                $('.ajax-loader').hide();
                $('#sync-error').show();
                $('#sync-error-msg').text(xhr.responseJSON.message);
                $('html, body').animate({
                    scrollTop: $("#error").offset().top
                }, 3000);
            }
        })
    });
</script>