@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'ASN History','parentTitle'=>'Settings','parentUrl'=>'/settings'])

<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox">
            <form action="" method="get" id="asset-filter-form">
                <div class="ibox-content">
                    
                    @include('partials.error-message')
                    
                    <div class="alert alert-danger sync-msg" id="sync-error" style="display: none;">
                        <span id="sync-error-msg"></span>
                        <a href="javascript:void(0)" onclick="$('#sync-error').hide();" class="close" data-dismiss="sync-msg" aria-label="close">×</a>
                    </div>
                    
                    <div class="alert alert-success sync-msg" id="sync-success" style="display: none;">
                        <span id="sync-success-msg"></span>
                        <a href="javascript:void(0)" onclick="$('#sync-success').hide();" class="close" data-dismiss="sync-msg" aria-label="close">×</a>
                    </div>
                    
                    @include('settings.asn-history.partials.filter')
                    <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                    
                    <table 
                    class="asn-history-table table table-stripped table-hover" 
                    data-page-length="50">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th >Supplier</th>
                            <th>Filename </th>
                            <th>Date Added</th>
                            <th>Download</th>
                            <th>Resync</th>
                        </tr>
                    </thead>
                    
                </table>
            </div>
        </form>
    </div>
</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.history'),'helpTitle'=>config('help-links.help_titles.history')])
@endsection

@section('after_scripts')
@include('settings.asn-history.partials.script')
@stop