@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Admin User'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-3">
                @include('settings.partials.side-nav')
            </div>
            <div class="col-lg-9">

                <div class="ibox">

                    <div class="ibox-content">

                        @can('Administrators Edit')
                        <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html" data-target="#addAdminUser">Add New</a></p>
                        @endcan

 <div class="form-group m-t">

                            <input type="text" class="form-control input-sm m-b-xs" id="filter"

                            placeholder="Find a user">

                        </div>
                        <table class="footable table table-stripped table-hover" data-page-size="25" data-filter=#filter id="admin-user-table">

                            <thead>

                                <tr>
                                    
                                    <th>#</th>

                                    <th>First Name</th>

                                    <th>Last Name</th>

                                    <th>Email</th>

                                    <th>User Role</th>
                              
                                </tr>

                            </thead>

                         

                        <tbody>
                                @forelse($users as $user)
                                <tr>
                                    <td style="display: none;">{{$user->id}}</td>

                                    <td>{{$loop->iteration}}</td>

                                    <td>{{$user->first_name}}</td>

                                    <td>{{$user->last_name}}</td>

                                    <td>{{$user->email}}</td>

                                    <td>{{$user->userType->name}}</td>

                                </tr>
                                @empty
                                    <tr>
                                        <td>No users in the system.</td>
                                    </tr>
                                @endforelse

                            </tbody>

                            <tfoot>

                                <tr>

                                    <td colspan="12">

                                        <ul class="pagination pull-right"></ul>

                                    </td>

                                </tr>

                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>


@stop

@section('after_scripts')

<div class="modal inmodal" id="addAdminUser" tabindex="-1" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span class="sr-only">Close</span></button>

                <h4 class="modal-title">Add New Admin User</h4>

            </div>

            <div class="modal-body">

                @include('partials.error')

                <form class="form-horizontal" action="" method="post" id="admin-user-form">
                    
                    {{csrf_field()}}
                    <div class="form-group">

                        <label class="col-lg-4 control-label">First Name</label>

                        <div class="col-lg-8">

                            <input type="text" class="form-control" name="first_name" value="{{old('first_name')}}" required autocomplete="off">

                         

                        </div>

                    </div>  

                     <div class="form-group">

                        <label class="col-lg-4 control-label">Last Name</label>

                        <div class="col-lg-8">

                            <input type="text" class="form-control" name="last_name" value="{{old('last_name')}}" required autocomplete="off">

                         

                        </div>

                    </div> 

                    <div class="form-group">

                        <label class="col-lg-4 control-label">Email</label>

                        <div class="col-lg-8">

                            <input type="text" class="form-control" name="email" value="{{old('email')}}" required autocomplete="off">

                         

                        </div>

                    </div> 
                    <!-- <div id="pwd-container">
                        <div class="form-group">

                            <label class="col-lg-4 control-label">Password</label>

                            <div class="col-lg-8">

                                <input type="password" class="form-control password-input" name="password" value="{{old('password')}}" required autocomplete="off">

                                <div class="pwstrength_viewport_verdict"></div>
                            </div>
                            
                        </div>  
                    </div>

                     <div class="form-group">

                        <label class="col-lg-4 control-label">Confirm Password</label>

                        <div class="col-lg-8">

                            <input type="password" class="form-control" name="password_confirmation" value="{{old('password_confirmation')}}" required autocomplete="off">

                        </div>

                     </div>  -->

                        <div class="form-group">

                             <label class="col-lg-4 control-label">User Type</label>

                                 <div class="col-lg-8">

                                        @include('partials.dropdowns.user-type',['usertype'=>'adminuser'])

                                  </div>

                         </div>
                            

                </form>

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                <button type="button" class="btn btn-primary" id="pw-submit">Save</button>

            </div>

        </div>

    </div>

</div>

<script>

    @if($errors->count() > 0)
        $("#addAdminUser").modal({show: true});
    @endif

  $(document).ready(function() {

        $('.footable').footable();

        $('#pw-submit').click(function(){
            $('#admin-user-form').submit();
        });

        @can('Administrators Edit')
        $('#admin-user-table').Tabledit({
            url: '/adminusers-ajax',
            columns: {
                identifier: [0, 'id'],
                editable:[[2, 'first_name'], [3, 'last_name'], [4, 'email'],[5, 'usertype','select',JSON.stringify({!!$adminuser!!})]],
            },
            restoreButton : false,
        });
        @endcan

    });
</script>

@stop

