@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Active Directory Credential'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-3">
                @include('settings.partials.side-nav')
            </div>
            <div class="col-lg-9">

                <div class="ibox">

                    <div class="ibox-content">

                        <!-- <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html" data-target="#addApiCredential">Add New</a></p> -->
                        @include('partials.success')
                        @include('partials.error-message')

                        @include('settings.partials.delete-message')

                        <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                            id="api-credential-table">

                            <thead>

                                <tr>
                                    <th>#</th>
                                    <th>Connect</th>
                                    <th>Status</th>
                                    <th>Import Users</th>
                                    <th>Export to Csv</th>
                                    <th>Clear Users</th>
                                    <th>URL</th>
                                    <th>Port Number</th>
                                    <th>User Name</th>
                                    <th></th>
                                </tr>

                            </thead>

                            <tbody>

                                @if($credentials)
                                <tr>
                                    <td>1</td>
                                    <td>
                                        <a href="{{route('active-directory.connect')}}"
                                            class="btn btn-primary btn-sm">Connect</a>
                                    </td>
                                    <td>
                                        @if ($status == 1)
                                        <button class="btn btn-primary btn-sm" disabled="disabled">Active</button>
                                        @else
                                        <button class="btn btn-danger btn-sm" disabled="disabled">Inactive</button>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($status == 1)
                                        <a href="{{route('active-directory.import')}}"
                                            class="btn btn-primary btn-sm">Import</a>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($status == 1)
                                        <a href="{{route('active-directory.export')}}"
                                            class="btn btn-primary btn-sm">Export</a>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($status == 1)
                                        <a href="{{route('active-directory.clear')}}"
                                            onclick="return confirm('Are you sure you want to delete all employees?')"
                                            class="btn btn-warning btn-sm">Clear Users</a>
                                        @endif
                                    </td>
                                    <td>{{$credentials->url}}</td>
                                    <td>{{$credentials->project}}</td>
                                    <td>{{$credentials->user_name}}</td>
                                    <td>@can('API Credentials Edit')<a
                                            href="{{route('active-directory.edit', ['active_directory' => $credentials->id])}}"><i
                                                class="icon icon-n-edit"></i></a>@endcan</td>
                                </tr>
                                @else
                                <tr>
                                    <td colspan="7">No Api Credentials in the system.</td>
                                </tr>
                                @endif

                            </tbody>

                            <tfoot>

                                <tr>

                                    <td colspan="7">

                                        <ul class="pagination pull-right"></ul>

                                    </td>

                                </tr>

                            </tfoot>

                        </table>

                        @if($status == 1)
                        <div class="row">
                            <div class="col-md-12">
                                <form method="post" action="/active-directory/search" class="form-inline">
                                    @csrf
                                    <div class="form-group">
                                        <label for="email">Email</label>
                                        <input type="email" name="email" class="form-control" placeholder="email"
                                            required>
                                    </div>
                                    <button class="btn btn-primary" type="submit">Search User</button>
                                </form>
                            </div>
                        </div>
                        @endif

                        @if($status == 1)
                        <form class="form-horizontal" action="/active-directory/upload" method="post"
                            enctype="multipart/form-data">
                            {{csrf_field()}}
                            <div class="row">
                                <div class="col-lg-9">
                                    <div class="form-group">
                                        <label class="col-lg-4 control-label">Bulk Upload Active Directory Users</label>
                                        <div class="col-lg-8">
                                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                                <div class="form-control" data-trigger="fileinput">
                                                    <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                                    <span class="fileinput-filename"></span>
                                                </div>
                                                <span class="input-group-addon btn btn-primary btn-file">
                                                    <span class="fileinput-new">Select file</span>
                                                    <span class="fileinput-exists">Change</span>
                                                    <input type="file" name="bulk_upload_users" />
                                                </span>
                                                <a href="#" class="input-group-addon btn btn-primary fileinput-exists"
                                                    data-dismiss="fileinput">Remove</a>
                                            </div>
                                            <a href="{{ '/template/active-directory-template.csv' }}"
                                        class="pull-right">Download Template File</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <input type="submit" class="btn btn-primary" value="Upload">
                                    
                                </div>
                            </div>
                        </form>
                        @endif

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>


@stop