@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit Active Directory Credential'])

<div class="wrapper-content">

    <div class="container-fluid">

    	<form class="form-horizontal" method="post" action="{{route('active-directory.update', ['active_directory' => $credential->id])}}"">

    		{{csrf_field()}}

    		@method('PUT')

	        <div class="row">

	        	@include('partials.error')

	            <div class="col-lg-12">

	            	<div class="ibox-content">
	                    
	                    <div class="form-group">
	                        <label class="col-lg-3 control-label">URL</label>
	                        <div class="col-lg-6">
	                            <input type="text" class="form-control" name="url" value="{{$credential->url}}">
	                        </div>
	                    </div>
						
						<div  class="form-group">
							<label class="col-lg-3 control-label">Port Number</label>
	                        <div class="col-lg-6">
	                            <input type="text" class="form-control" name="port_number" value="{{$credential->project}}">
	                        </div>
						</div>

						<div class="form-group">
	                        <label class="col-lg-3 control-label">User Name</label>
	                        <div class="col-lg-6">
	                            <input type="text" class="form-control" name="user_name" value="{{$credential->user_name}}">
	                        </div>
	                    </div>

						<div class="form-group">
	                        <label class="col-lg-3 control-label">Password</label>
	                        <div class="col-lg-6">
	                            <input type="text" class="form-control" name="password" value="">
	                            <span class="help-block m-b-none">To keep the old password, leave this empty</span>
	                        </div>
	                    </div>

	                    <div class="form-group">
							<div class="col-lg-offset-3 col-lg-1">
								<button class="btn btn-primary" name="commit" type="submit">Save</button>
							</div>
						</div>

	                </div>

		        
		        </div>
		    </div>
		</form>

	</div>
</div>
@stop

@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop