<script>

  $(document).ready(function () {

    var table = $('.footable').DataTable({
      
      fixedHeader:true,
      "scrollX": true,
      fixedColumns: true,
      fixedColumns: {
        left: 3
      },
      "processing": true,
      
      "serverSide": true,
      "ajax": {
        "url": "{{ route('sensor-vulnerability-data') }}",
        "dataType": "json",
        "type": "POST",
        "data": function (result) {
          result.form = $('#search-form').serializeObject();
        }
      },
      "columns": [
        {"data":'id'},
        {"data":'asset_tag'},
        {"data":'serial'},
        {"data":'hardware_standard'},
        {"data":'tech_specs'},
        {"data":'asset_status'},
        {"data":'userlocation'},
        {"data":'user_work_location'},
        {"data":'cve_id'},
        {"data":'exprt_rating'},
        {"data":'severity'},
        {"data":'product_name'},
        {"data":'product_version'},
        {"data":'days_open'}
      ],
      lengthMenu: [
      [50, 100, 200],
      ['50', '100', '200']
      ],
      columnDefs: [
      { orderable: false, targets: '_all' }
      ],
      "aaSorting": [],
      "dom": '<"top"i>rt<"bottom"flp><"clear">',
      "bAutoWidth": false,
      "bFilter": true,
      "bLengthChange": false,
      "searching": false,
      "fnDrawCallback": function (oSettings) {
        if (table.page.info().recordsTotal == 0) {
          $("#export-csv").hide();
        } else {
          $("#export-csv").show();
        }
      }
    });

    //Datatable column toggler
    $('span.col-toggle').on('click', function (e) {
      e.preventDefault();
      $(this).toggleClass('col-hidden');
      // Get the column API object
      var column = table.column($(this).attr('data-column'));
      
      // Toggle the visibility
      column.visible(!column.visible());
      // // Add class to responsive breakpoint list item
      var columnIndex = column.index();
      var thClassName = column.header().className;
      // console.log(columnIndex);
      $('.dataTables_wrapper').find('li[data-dt-column="'+columnIndex+'"]').addClass(thClassName);
    });

    
    $('#search-form').submit(function (e) {
      e.preventDefault();
      table.draw();
    });
    
    $('#export-csv').on('click', function (e) {
      e.preventDefault();
      $('.ajax-loader').show();
      $.ajax({
        type: "POST",
        url: "{{route('sensor-vulnerability-export')}}",
        data: $('#search-form').serializeObject(),
        dataType: 'text',
        success: function (result) {
          var blob = new Blob([result]);
          if (window.navigator.msSaveOrOpenBlob)
          window.navigator.msSaveBlob(blob, "assets-vulnerability-report.csv");
          else {
            var a = window.document.createElement("a");
            a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
            a.download = "assets-vulnerability-report.csv";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
          }
          $('.ajax-loader').hide();
        }
      })
    });

  });
</script>