<script>
  $(document).ready(function() {

    var table = $('.footable').DataTable({
      fixedHeader: true,
      "scrollX": true,
      scrollY: '400px',
      scrollCollapse: true,
      fixedColumns: true,
      fixedColumns: {
        left: 3
      },
      "processing": true,

      "serverSide": true,
      "ajax": {
        "url": "{{ route('sensor-detection-data') }}",
        "dataType": "json",
        "type": "POST",
        "data": function(result) {
          result.form = $('#search-form').serializeObject();
        }
      },
      "columns": [
        {"data": 'id'},
        {"data": 'asset_tag'},
        {"data": 'serial'},
        {"data": 'asset_status'},
        {"data": 'hardware_standard'},
        {"data": 'tech_specs'},
        {"data": 'userlocation'},
        {"data": 'user_work_location'},
        {"data": 'sensor_installed' }
      ],
      lengthMenu: [
        [50, 100, 200],
        ['50', '100', '200']
      ],
      columnDefs: [{
        orderable: false,
        targets: '_all'
      }],
      "aaSorting": [],
      "dom": '<"top"i>rt<"bottom"flp><"clear">',
      "bAutoWidth": false,
      "bFilter": true,
      "bLengthChange": false,
      "searching": false,
      "fnDrawCallback": function(oSettings) {
        if (table.page.info().recordsTotal == 0) {
          $("#export-csv").hide();
        } else {
          $("#export-csv").show();
        }
      }
    });

    //Datatable column toggler
    $('span.col-toggle').on('click', function (e) {
      e.preventDefault();
      $(this).toggleClass('col-hidden');
      // Get the column API object
      var column = table.column($(this).attr('data-column'));
      
      // Toggle the visibility
      column.visible(!column.visible());
      // // Add class to responsive breakpoint list item
      var columnIndex = column.index();
      var thClassName = column.header().className;
      // console.log(columnIndex);
      $('.dataTables_wrapper').find('li[data-dt-column="'+columnIndex+'"]').addClass(thClassName);
    });


    // export csv    
    $('#export-csv').on('click', function(e) {
      e.preventDefault();
      $('.ajax-loader').show();
      $.ajax({
        type: "POST",
        url: "{{route('sensor-detection-export')}}",
        data: $('#search-form').serializeObject(),
        dataType: 'text',
        success: function(result) {
          var blob = new Blob([result]);
          if (window.navigator.msSaveOrOpenBlob)
            window.navigator.msSaveBlob(blob, "sensor-detection-report.csv");
          else {
            var a = window.document.createElement("a");
            a.href = window.URL.createObjectURL(blob, {
              type: "text/plain"
            });
            a.download = "sensor-detection-report.csv";
            document.body.appendChild(a);
            a.click(); 
            document.body.removeChild(a);
          }
          $('.ajax-loader').hide();
        }
      })
    });

    //table draw on search form submit
    $('#search-form').submit(function (e) {
      e.preventDefault();
      table.draw();
    });

  });
</script>