@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Sensor Detection', 'parentUrl' => '#', 'parentTitle' =>
'Crowdstrike'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            @include('security.crowdstrike.sensor-detection.partials.filter')
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <div class="ibox-tools legend-container-ibox">
                            <div>
                                <div id="legend-container"></div>
                            </div>
                            <div>
                                <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                            </div>
                        </div>
                    </div>
                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

                        @include('security.crowdstrike.sensor-detection.partials.table-togglers')

                        
                            <table class="footable table table-stripped table-hover nowrap three-col-fixed" data-page-size="50" data-filter=#filter>

                                <thead>

                                    <tr>

                                        @include('security.crowdstrike.sensor-detection.partials.table-theads')

                                    </tr>

                                </thead>

                                <tbody>

                                </tbody>

                            </table>

                        

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
@stop

@section('after_scripts')
@include('security.crowdstrike.scripts.common')
@include('security.crowdstrike.sensor-detection.scripts.list')
@stop