<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedColumns.min.js"></script>
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">

<script>

  $(document).ready(function () {

    // serialize form 
    $.fn.serializeObject = function () {
      var obj = {};

      $.each(this.serializeArray(), function (i, o) {
        var n = o.name, v = o.value;

        obj[n] = obj[n] === undefined ? v
          : $.isArray(obj[n]) ? obj[n].concat(v)
            : [obj[n], v];
      });

      return obj;
    };


    // table draw on filter field change
    $(".report-filter").on('change', function () {
      $('#search-form').submit();
    });

    $(".report-filter").on('input', function () {
        $('#search-form').submit();
    });


    // chosen initialisation
    $('.chosen-select').chosen({width: "100%"}).change(function() {
      $(this).closest('.form-group').next().find('input').focus();
    });

    $('.date-fields').datepicker({
        todayBtn: "linked",
        clearBtn: true,
        keyboardNavigation: false,
        forceParse: false,
        calendarWeeks: false,
        autoclose: true
    });

    // filters management

    $(".filter-field").each(function() {
        var name = $(this).attr('key');
        $( this ).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '/get-filter-fields',
                dataType: "json",
                data: function (params){
                  var query = {
                    search: params.term,
                    type: name
                  }

                  // Query parameters will be ?search=[term]&type=public
                  return query;
                },
                processResults: function (data) {
                  // Tranforms the top-level key of the response object from 'items' to 'results'
                  return {
                    results: data
                  };
                },

            }
        });
    });

    $(".filter-field-user").each(function () {
			$(this).select2({
				minimumInputLength: 1,
				multiple: true,
				ajax: {
					url: '/get-filter-fields-user',
					dataType: "json",
					data: function (params) {
						var query = {
							search: params.term
						}

						// Query parameters will be ?search=[term]&type=public
						return query;
					},
					processResults: function (data) {
						// Tranforms the top-level key of the response object from 'items' to 'results'
						return {
							results: data
						};
					},

				}
			});
		});

    $(".filter-field-location").each(function () {
            var name = $(this).attr('key');
            $(this).select2({
                minimumInputLength: 1,
                ajax: {
                    url: '/get-filter-fields-location',
                    dataType: "json",
                    data: function (params) {
                        var query = {
                            search: params.term,
                            type: name
                        }
                        
                        return query;
                    },
                    processResults: function (data) {

                        return {
                            results: data
                        };
                    },
                    
                }
            });
    });

    $(".filter-vulnerability-field").each(function () {
        var name = $(this).attr('key');
        $(this).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '/get-filter-fields-vulnerability',
                dataType: "json",
                data: function (params) {
                    var query = {
                        search: params.term,
                        type: name
                    }

                    return query;
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                },

            }
        });
    });

});
</script>


    