@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Active CVEs', 'parentUrl' => '#', 'parentTitle' =>
'Crowdstrike'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-6">
                <div class="ibox">
                    <div class="ibox-content match-height-block">
                        <dl class="dl-horizontal">
                            <dt>CVE ID</dt>
                            <dd>{{$cveData->cve_id}}</dd>
                            <dt>Base Score</dt>
                            <dd>{{$cveData->base_score}}</dd>
                            <dt>ExPRT Rating</dt>
                            <dd>{{$cveData->exprt_rating}}</dd>
                            <dt>Severity</dt>
                            <dd>{{$cveData->severity}}</dd>
                            <dt>Status</dt>
                            <dd>{{$cveData->severity}}</dd>
                            <dt>Exploitability Score</dt>
                            <dd>{{$cveData->exploitability_score}}</dd>
                            <dt>Published Date</dt>
                            <dd>{{parse_date_from_db_datetime($cveData->cve_published)}}</dd>
                            <dt>Description</dt>
                            <dd>{{$cveData->description}}</dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="ibox">
                    <div class="ibox-content match-height-block">
                        <dl class="dl-horizontal">
                            <dt>Total Assets</dt>
                            <dd>{{ $totalAssetsCount }}</dd>
                            @foreach ($csvWidgetData['assetTypeWithCount'] as $assetTypes)
                                <dt>{{ $assetTypes->name }}</dt>
                                <dd>{{ $assetTypes->asset_count }}</dd>
                            @endforeach
                        </dl>
                    </div>
                </div>
            </div>
        </div>


        @include('security.crowdstrike.active-cve.cve-vulnerabilities')
        
        
    </div>
</div>
@stop

@section('after_scripts')
@include('security.crowdstrike.scripts.common')
@include('security.crowdstrike.active-cve.scripts.detail')
@stop
