@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Revivn - Pickups', 'parentSubUrl' => '#', 'parentSubTitle' => 'Revivn','parentUrl' => '#', 'parentTitle' => ' Inventory Control '])
@include('revivn.partials.submenu')

	<div class="wrapper-content">

        <div class="container-fluid">

            @include('revivn.partials.filter.revivn-pickups')
            
            <div class="ibox">

                <div class="ibox-content">
                    
                    <div class="ibox-tools">

                        <button type="button" id="export-csv" class="btn btn-primary" data-file-name="revivn-pickups-report" data-url="{{ route('revivn-pickups-export') }}">Export to CSV</button>

                    </div>
                
                
                    @include('partials.success')
                    @include('partials.error-message')
                    <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

                    <div class="dt-coltoggler-wrapper ">
                        <p>Click to toggle table columns: </p>
                    </div>

                    <table class="table table-striped nowrap has-column-toggler" data-filter-form="#search-form" data-role="ui-data-table" data-url="{{ route('revivn-pickups-data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true">

                        <thead>
                            <th data-col-name="id">#</th>
                                                                
                            <th data-col-name="pickup_id">Pickup ID</th>
                                                                        
                            <th data-col-name="state">State</th>

                            <th data-col-name="order">Order #</th>
                                                                
                            <th data-col-name="comments">Comments</th>
                            
                            <th data-col-name="confirmed_time">Confirmed Time</th>

                            <th data-col-name="scheduled_date">Scheduled Date</th>

                        </thead>

                        <tbody>
                            
                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>

@stop

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('reports.scripts.datatable-column-toggle-script');

@stop

