@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Revivn - Devices Auto Created', 'parentSubUrl' => '#', 'parentSubTitle' => 'Revivn','parentUrl' => '#', 'parentTitle' => ' Inventory Control '])
@include('revivn.partials.submenu')

<div class="wrapper-content">

<div class="container-fluid">

    
    @include('revivn.partials.filter.revivn-assets-auto-created-filter')
    
    <div class="ibox">

        <div class="ibox-content">
            
            <div class="ibox-tools">

                <button type="button" id="export-csv" class="btn btn-primary" data-file-name="revivn-assets-auto-created-report" data-url="{{ route('revivn-assets-auto-created-export') }}">Export to CSV</button>

            </div>
        
        
            @include('partials.success')
            @include('partials.error-message')
            @include('partials.sync-messages')
            <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

            <div class="dt-coltoggler-wrapper ">
                <p>Click to toggle table columns: </p>
            </div>
            
            <table class="table table-striped nowrap has-column-toggler" data-filter-form="#search-form" data-role="ui-data-table" data-url="{{ route('revivn-assets-auto-created-data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true">

                <thead>

                    <th data-col-name="id">#</th>
                                                        
                    <th data-col-name="serial">Serial #</th>
                                                                
                    <th data-col-name="asset_type">Asset Type</th>

                    <th data-col-name="manufacturer">Manufacturer</th>
                                                        
                    <th data-col-name="hardware_standard">Hardware Standard</th>
                    
                    <th data-col-name="tech_specs">Tech Specs</th>

                    <th data-col-name="hard_drive">Hard Drive</th>

                    <th data-col-name="ram">RAM</th>

                    <th data-col-name="end_of_life_condition">End Of Life Condition</th>

                    <th data-col-name="status">Status</th>

                    <th data-col-name="pickup_id">Pickup ID</th>

                    <th data-col-name="state">State</th>

                    <th data-col-name="order">Order #</th>

                    <th data-col-name="year">Year</th>
                    
                    <th data-col-name="date_added">Date Added</th>

                    <th data-col-name="action_button"></th>


                    </tr>

                </thead>

                <tbody>
                    
                </tbody>

            </table>

        </div>

    </div>
</div>

@include('revivn.partials.modals.revivn-asset-edit-modal')

@stop

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('reports.scripts.datatable-column-toggle-script');
@include('revivn.partials.script.revivn-assets-auto-created')

@stop

