
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>

<script>
    $(document).ready(function() {
        // Initialize select2 and fills the filter fields
        $(".filter-field").each(function() {
            var name = $(this).attr('key');
            $(this).select2({
                tokenizer: function(input, s2, callback) {
                    var term = input.term;
                    if (term.indexOf(',') < 0) return input; // Exit if no tokens
                    var parts = term.split(",");
                    for (var i = 0; i < parts.length; i++) {
                        var part = parts[i].trim();
                        if (part.length > 2) {
                            $.ajax({
                                url: s2.options.ajax.url,
                                dataType: s2.options.ajax.dataType,
                                data: s2.options.ajax.data({
                                    term: part
                                }),
                                async: false, // If async then unable to return unmatched tokens
                                success: function(data) {
                                    var pr = s2.options.ajax.processResults(data, {
                                        term: part
                                    });
                                    if (pr.results[0].value != 0) {
                                        callback(pr.results[0]);
                                        parts.splice(i--, 1);
                                    }
                                }
                            });
                        }
                    }
                    return {
                        term: parts.join(',')
                    }; // Rejoin unmatched tokens
                },
                minimumInputLength: 1,
                multiple: true,
                ajax: {
                    url: '/get-filter-fields',
                    dataType: "json",
                    data: function(params) {
                        var query = {
                            search: params.term,
                            type: name
                        };
                        return query;
                    },
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                }
            });
        });

        $(".filter-revivn-field").each(function() {
            var name = $(this).attr('key');
            $( this ).select2({
                minimumInputLength: 1,
                multiple: true,
                ajax: {
                    url: '/inventory-control/revivn-assets/get-filter-fields',
                    dataType: "json",
                    data: function (params){
                      var query = {
                        search: params.term,
                        type: name
                      }

                      // Query parameters will be ?search=[term]&type=public
                      return query;
                    },
                    processResults: function (data) {
                      // Tranforms the top-level key of the response object from 'items' to 'results'
                      return {
                        results: data
                      };
                    },

                }
            });
        });

        // Fill data to the edit modal on show
        $('#editModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('asset-id');
            $.ajax({
                type: "POST",
                url: "revivn-asset-get/" + id,
                success: function (value) {
                    $('#modal_asset_id').val(id);
                    $('#asset_description').html(value['serial_no']);
                    $('#modal_asset_type').val(value['assettype']);
                    $('#modal_asset_type').trigger("chosen:updated");
                    getHardwareStandards(value['hardware'], value['assettype']);
                    getTechSpecs(value['hardware'], value['techspec'])

                    $('#modal_hardware').val(value['hardware']);
                    $('#modal_tech').val(value['techspec']);

                }
            });
        });

        // Handle asset type change to get hardware
        $('#modal_asset_type').change(function (e) {
            var assettype = this.value;
            getHardwareStandards(0, assettype);
        });

        // Handle hardware change to get tech specs
        $('#modal_hardware').change(function (e) {
            var currentHardware = this.value;
            getTechSpecs(currentHardware, 0);
        });

        // Handle revivn edit form submit
        $('#edit-revivn-asset-form').submit(function (e) {
            e.preventDefault();
        }).validate({
            onkeyup: false,
            ignore: ':disabled',
            rules: {
                'asset_type_id': {
                    required: true
                },
                'make_and_model_id': {
                    required: true
                },
                'technical_spec': {
                    required: true
                }
            },
            submitHandler: function(form) {
            
                $('#error').hide();
                $('#success').hide();
                $.ajax({
                    type: "POST",
                    url: "/revivn-asset-update",
                    data: $('#edit-revivn-asset-form').serializeObject(),
                    dataType: 'json',
                    success: function (data) {
                        $('#editModal').modal('hide')
                        $('#sync-success-msg').text("Updated successfully.");
                        table.draw();
                        $('#sync-success').show();
                        $('html, body').animate({
                            scrollTop: $("#sync-error").offset().top
                        }, 1000);
                    },
                    error: function (xhr) {
                        // Handle errors in the AJAX request
                        if (xhr.status === 422) {
                            // Validation errors
                            $('#editModal').modal('hide')
                            var response = JSON.parse(xhr.responseText);
                            var errorString = '<ul>';
                            $.each(response.errors, function (key, value) {
                                errorString += '<li>' + value + '</li>';
                            });
                            errorString += '</ul>';

                            $('#sync-error').show();
                            $('#sync-error-msg').html(errorString);
                            $('html, body').animate({
                                scrollTop: $("#sync-error").offset().top
                            }, 3000);
                        }
                    }
                });
            }
        
        });

    });

    // Get Hardware Standards based on asset type
    function getHardwareStandards(currentHardware, assettype) {
        $.ajax({
            type: "POST",
            url: "/revivn-asset-get-hardware",
            dataType: 'json',
            data: { assettype: assettype, "_token": "{{ csrf_token() }}" },
            dataType: 'text',
            success: function (outputfromserver) {
                var data = JSON.parse(outputfromserver);
                $('#modal_hardware').empty();
                $('#modal_hardware').append($("<option></option>")
                .attr("value", "")
                .text("Select"));

                $.each(data, function (key, value) {
                    $('#modal_hardware')
                    .append($("<option></option>")
                    .attr("value", key)
                    .text(value));
                });
                if (currentHardware != 0) {
                    $('#modal_hardware').val(currentHardware);
                }
                $('#modal_hardware').trigger("chosen:updated");
            }
        });
    }

    // Get Tech Specs based on hardware
    function getTechSpecs(currentHardware, currentTechSpec) {

        $.ajax({
            type: "POST",
            data: { id: currentHardware },
            url: "/assets-filter/listtechnics",
            success: function (data) {
                $('#modal_tech').empty().trigger('chosen:updated');

                $('#modal_tech').append($('<option>', {
                    value: '',
                    text: 'Select'
                }));

                $.each(data, function (key, value) {
                    $('#modal_tech').append($('<option>', {
                        value: value.id,
                        text: value.details
                    }));
                })
                if (currentTechSpec != 0) {
                    $('#modal_tech').val(currentTechSpec);
                }
                $('#modal_tech').trigger("chosen:updated");

            }
        });
    }
</script>
