<div class="ibox">
    <div class="ibox-title">
		<div class="ibox-tools">
			<h5>Filters</h5>
			<a data-toggle="collapse" href="#collapseFilter" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
		</div>
	</div>
	<div class="collapse in" id="collapseFilter">
		<div class="ibox-content">
            <form method="post" id="search-form" action="">
                {{ csrf_field() }}
                <div class="row">
                    <!-- Serial Number Filter -->
                    <div class="col-md-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Serial #</label>
                            <select class="report-filters filter-field form-control" multiple name="serial_no" key="serial_no" id='serial_no' data-placeholder="Select">
                                <!-- Options for Serial Number -->
                            </select>
                        </div>
                    </div>

                    <!-- Asset Type -->
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Type </label>
                            <select class="report-filters chosen-select" id="asset_type" multiple name="asset_type" data-placeholder="Select">
                                @foreach(\App\Models\AssetType::get() as $assetType)
                                <option value="{{$assetType->id}}" >{{$assetType->name}}</option>
                                @endforeach                             
                            </select>
                        </div>  
                    </div>
                
                    <!-- Manufacturer Filter -->
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Manufacturer </label>
                            <select class="report-filters chosen-select" id="manufacturer" multiple name="manufacturer" data-placeholder="Select">
                                @foreach(\App\Models\Manufacturer::get() as $manufacturer)
                                <option value="{{$manufacturer->id}}" >{{$manufacturer->name}}</option>
                                @endforeach                             
                            </select>
                        </div>  
                    </div>

                    <!-- Hardware Standard Filter -->
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Hardware Standard</label>
                            <select class="report-filters form-control select2" multiple name="make_and_model" id="make_and_model" data-placeholder="Select">
                                @foreach(Facades\App\Repositories\HardwareStandards::getHardwareStandards() as $hardware)
                                <option value="{{ $hardware->id }}">{{ $hardware->hardware }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    </div>

                <div class="row">

                    <!-- Tech Specs Filter -->
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Tech Specs</label>
                            <select class="report-filters form-control select2" multiple name="technical_spec" id="technical_spec" data-placeholder="Select">
                                @foreach(\App\Models\TechnicalSpecs::getWithoutAccessories()->where('details', '<>', '')->get() as $technicalSpec)
                                <option value="{{ $technicalSpec->id }}">{{ $technicalSpec->details }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <!-- Pickup ID Filter -->
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Pickup ID </label>
                            <select class="report-filters chosen-select" id="pickup_id" multiple name="pickup_id" data-placeholder="Select">
                                @foreach(\App\Models\RevivnPickup::groupBy('pickup_id')->get() as $pickup)
                                <option value="{{$pickup->pickup_id}}" >{{$pickup->pickup_id}}</option>
                                @endforeach                             
                            </select>
                        </div>  
                    </div>

                    <div class="col-md-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Hard Drive</label>
                            <select class="report-filters filter-revivn-field form-control" multiple name="hard_drive" key="hard_drive" id='hard_drive' data-placeholder="Select">
                                <!-- Options for Serial Number -->
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">RAM</label>
                            <select class="report-filters filter-revivn-field form-control" multiple name="ram" key="ram" id='ram' data-placeholder="Select">
                                <!-- Options for Serial Number -->
                            </select>
                        </div>
                    </div>

                

                </div>

                <div class="row">
                    <!-- Tech Specs Filter -->
                    <div class="col-md-3"> 
                        <div class="form-group">
                            <label class="control-label">Year</label>
                            <select class="report-filters filter-revivn-field form-control" multiple name="year" key="year" id='year' data-placeholder="Select">
                                <!-- Options for Serial Number -->
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Date Added From</label>
                            <div class="form-group" id="data_1">
                                <div class="input-group date">
                                    <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
                                        type="text" name="date_added_from" class="form-control" value=""
                                        placeholder="From" readonly>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Date Added To</label>

                            <div class="form-group" id="data_1">
                                <div class="input-group date">
                                    <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
                                        type="text" class="form-control" value="" placeholder="To"
                                        name="date_added_to" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </form>
        </div>
    </div>
</div>

