<script>

    $(document).ready(function() {

        var table = $('.footable').DataTable({
            fixedHeader: {
                header: true,
            },
            fixedColumns: true,
			fixedColumns: {
				left: 3
			},
			"scrollX": true,
            "processing": true,
            "serverSide": true,
            "ajax":{
                "url": "{{ route('warranty-expiration-date-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "serial_no" },
                { "data": "asset_tag" },
                { "data": "hardware_standard" },
                { "data": "tech_specs" },
                { "data": "location" },
                { "data": "user_location" },
                { "data": "asset_status" },
                { "data": "warranty_start_date" },
                { "data": "warranty_end_date" },
                { "data": "days_to_expire" },
            ],
            lengthMenu: [
				[10, 25, 50, 100],
            	[10, 25, 50, 100]
			],
			iDisplayLength: 50,
            columnDefs: [
               { orderable: false, targets: '_all' }
            ],
            "aaSorting": [],
            "bAutoWidth": false,
            "bFilter": true,
            "searching": false,
            "fnDrawCallback": function (oSettings) {
                if (table.page.info().recordsTotal == 0) {
                    $("#export-csv").hide();
                } else {
                    $("#export-csv").show();
                }
            },
        });

        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "/report/warranty-expiration-date-export",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    var filename = "warranty-expiration-date.csv"
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, filename);
                    else
                    {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });



        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });



    $("#make_and_model").change(function(){
        if ($(this).val() != '' && $(this).val() != '--Select--' && $(this).val() != '0') {
            $.ajax({
                type: "POST",
                data:{id:$(this).val()},
                url: "/assets-filter/listtechnics",
                success: function(data) {
                    $('#technical_spec').empty();
                    $('#technical_spec').append($('<option>', {
                          value: 0,
                          text: "--Select--"
                         }));
                    $("#technical_spec").select2();
                    $.each(data,function (key,value) {
                        $('#technical_spec').append($('<option>', {
                          value: value.id,
                          text: value.details
                         }));
                    });
                },
                error: function(value) {

                }
            });
        }
    });

    });


</script>