@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Warranty Expiration Date', 'parentUrl' => '/report', 'parentTitle' =>
'Reports'])
<div class="wrapper-content">
    <div class="container-fluid ">
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <h5>Filters</h5>
                            <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
                        </div>
                    </div>
                    <div class="collapse in" id="collapseFilter">
                        <div class="ibox-content">
                            <form method="post" id="search-form" action="">
                                {{ csrf_field() }}
                                <div class="row">

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label">Serial #</label>
                                            <select class="filter-field form-control" multiple name="serial_no"
                                                id="serial_no" key="serial_no" data-placeholder="Select">
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label">Asset Tag #</label>
                                            <select class="filter-field form-control" multiple name="asset_tag"
                                                id="asset_tag" key="asset_tag" data-placeholder="Select">
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label">Asset Status</label>
                                            <select class="chosen-select filter-input" multiple name="status"
                                                id="status" data-placeholder="Select">
                                                @foreach(\App\Models\AssetStatus::reportStatus()->orderBy('name')->get() as $status)
                                                <option value="{{$status->id}}">{{$status->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label">Hardware Standard</label>
                                            <select class="form-control select2 filter-input" multiple
                                                name="make_and_model" id="make_and_model" data-placeholder="Select">
                                                @foreach(App\Models\MakeAndModel::getWithAssetTypes(config('reports.warranty_expiration_date.include_asset_types'))->valid()->orderBy('name', 'ASC')->get() as $hardware)
                                                <option value="{{$hardware->id}}">{{$hardware->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label">Technical Specs</label>
                                            <select class="form-control select2 filter-input" multiple
                                                name="technical_spec" id="technical_spec" data-placeholder="Select">
                                                @foreach(\App\Models\TechnicalSpecs::getWithAssetTypes(config('reports.warranty_expiration_date.include_asset_types'))->orderBy('details', 'ASC')->get() as $technicalSpec)
                                                    <option value="{{$technicalSpec->id}}">{{ $technicalSpec->details}}
                                                    </option>
                                                    @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label">User</label>
                                            <select class="filter-field-user select2 form-control filter-input" multiple
                                                name="user" id="user" key="user" data-placeholder="Select">
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-3 divHeight">
                                        <div class="form-group">
                                            <label class="control-label">User Work Location</label>
                                            <select class="filter-field-location form-control" multiple name="location"
                                                key="city" id="location" data-placeholder="Select">
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Days To Expire</label>
                                                <select class=" form-control filter-input" name="days_to_expire"
                                                    id="days_to_expire">
                                                    <option value="0"> Select </option>
                                                    <option value="0~30"> 0-30 days </option>
                                                    <option value="31~60"> 31-60 days </option>
                                                    <option value="61~90"> 61-90 days </option>
                                                    <option value="90~"> 91+ days </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Warranty Start Date Range</label>
                                            <div class="form-group" id="data_1">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i
                                                            class="icon icon-calendar-2"></i></span><input type="text"
                                                        name="warranty_start_date_from" id="warranty_start_date_from"
                                                        class="form-control date-picker-input" placeholder="From"
                                                        value="">
                                                </div>
                                            </div>

                                            <div class="form-group" id="data_1">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i
                                                            class="icon icon-calendar-2"></i></span><input type="text"
                                                        class="form-control date-picker-input"
                                                        id="warranty_start_date_to" placeholder="To"
                                                        name="warranty_start_date_to" value="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Warranty End Date Range</label>
                                            <div class="form-group" id="data_1">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i
                                                            class="icon icon-calendar-2"></i></span><input type="text"
                                                        name="warranty_end_date_from" id="warranty_end_date_from"
                                                        class="form-control date-picker-input" placeholder="From"
                                                        value="">
                                                </div>
                                            </div>

                                            <div class="form-group" id="data_1">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i
                                                            class="icon icon-calendar-2"></i></span><input type="text"
                                                        class="form-control date-picker-input" id="warranty_end_date_to"
                                                        placeholder="To" name="warranty_end_date_to" value="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="ibox">

                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <button type="button" id="export-csv" class="btn btn-primary">Export to CSV</button>
                        </div>
                    </div>

                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>


                        <table class="footable table table-stripped table-hover nowrap three-col-fixed" data-page-size="50" data-filter=#filter>

                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Serial #</th>

                                    <th>Asset Tag #</th>

                                    <th>Hardware Standard</th>

                                    <th>Technical Specs</th>

                                    <th>User / Location</th>

                                    <th>Work Location</th>

                                    <th>Asset Status</th>

                                    <th>Warranty Start Date</th>

                                    <th>Warranty End Date</th>

                                    <th># of days to expire</th>

                                </tr>

                            </thead>

                            <tbody>


                            </tbody>

                        </table>


                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.asset_reports'),'helpTitle'=>config('help-links.help_titles.asset_reports')])
@endsection

@section('after_scripts')

@include('reports.scripts.common')
@include('reports.warranty-expiration-date.scripts.script')

@stop