<div class="col-lg-12">
    <div class="ibox">
        <div class="ibox-title">
            <div class="ibox-tools">
                <h5>Filters</h5>
                <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"
                    ><i class="icon icon-e-delete"></i></a>
            </div>
        </div>
        <div class="collapse in" id="collapseFilter" aria-expanded="true">
            <div class="ibox-content">
                <form action="{{ route('users-to-asset-ratio-graph-data') }}" method="post" id="search-form">
                    {{csrf_field()}}
                    <div class="row">
                        
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Asset Type </label>
                                <select class="chosen-select" id="asset-type" name="asset-type[]" multiple  data-placeholder="Select">
                                    @foreach($filterDataOptions['assetTypes'] as $assetType)
                                    <option value="{{$assetType->id}}">{{$assetType->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Asset Status</label>
                                <select class="chosen-select" id="asset-status" multiple name="asset-status[]" data-placeholder="Select">
                                    @foreach($filterDataOptions['assetStatus'] as $status)
                                        <option value="{{$status->id}}">{{$status->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Shows Users With Assets Total</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <select class="chosen-select" id="asset-from" name="asset-from" data-placeholder="From">
                                            <option value="">From</option>
                                            @for($i=1; $i < 15; $i++)
                                                <option value="{{$i}}">{{$i}}</option>
                                            @endfor
                                            <option value="15">15+</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <select class="chosen-select" id="asset-to" name="asset-to" data-placeholder="To">
                                            <option value="">To</option>
                                            @for($i=1; $i < 15; $i++)
                                                <option value="{{$i}}">{{$i}}</option>
                                            @endfor
                                            <option value="15">15+</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">User Type</label>
                                <select class="chosen-select" id="employee_type" multiple name="employee_type[]" data-placeholder="Select">
                                    @foreach(\App\Models\EmployeeType::has('users')->orderBy('name')->where('slug', '!=', 'full_time')->get() as $type)
                                    <option value="{{$type->id}}">{{$type->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Work Location</label>
                                <select class="form-control select2 filter-field-location" multiple id="work_location" name="work_location[]" key="city" data-placeholder="Select">
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Department</label>
                                <select class="chosen-select" multiple name="department[]" id="department" data-placeholder="Select">
                                    @foreach(\App\Models\Department::orderBy('name')->get() as $department)
                                    <option value="{{$department->id}}" @if(is_array(request('department')) && in_array($department->id,request('department'))) selected="selected" @endif>{{$department->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">User Status</label>
                                <select class="chosen-select" name="user-status" id="user-status" data-placeholder="Select">
                                    <option value="">Show All</option>
                                    <option value="1">Active</option>
                                    <option value="2">Inactive</option>
                                </select>
                            </div>
                        </div>

                        <input type="hidden" name="multiple" id="multiple" value="0">
                        <input type="submit" name="submit" id="submit" style="display: none" value="submit">

                    </div>
                </form>
            </div>
        </div>
    </div>
</div>