@extends('layouts.main')
@section('content')


@include('partials.breadcrumb', ['breadcrumbTitle' => 'Use Tax Report', 'parentUrl' => '/report', 'parentTitle' => 'Reports'])
<div class="wrapper-content">

    <div class="container-fluid">
        @include('reports.use-tax.partials.use-tax-filters')

        <div class="ibox">
            <div class="ibox-content">
                <div class="ibox-tools">
                    <a href="#" id="export-csv" class="btn btn-primary" data-url="{{ route('use-tax-report-export') }}" data-file-name="use-tax-export">Export to CSV</a>
                </div>
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
                </div>
                <table class="footable table table-stripped table-hover nowrap three-col-fixed has-column-toggler" data-role="ui-data-table" data-page-size="50" data-url="{{ route('use-tax-report-data') }}" id="assets-table" data-searching="false" data-ordering="false" data-fixed-header="true" data-fixed-header-columns-left="3">
                    <thead>
                        <tr>
                            <th data-col-name="id">#</th>
                            <th data-col-name="asset_tag">Asset Tag #</th>
                            <th data-col-name="serial_no">Serial #</th>
                            <th data-col-name="type">Asset Type</th>
                            <th data-col-name="hardware_standard">Hardware Standard</th>
                            <th data-col-name="asset_age">Asset Age</th>
                            <th data-col-name="purchase_date">Purchase Date</th>
                            <th data-col-name="status">Asset Status</th>
                            <th data-col-name="origin_location">Origin Location</th>
                            <th data-col-name="location_user">User/Location</th>
                            <th data-col-name="days_at_location">Days at Current Location</th>
                            <th data-col-name="work_location">User Work Location</th>
                            <th data-col-name="department">Department</th>
                            <th data-col-name="hire_date">Hire Date</th>
                            <th data-col-name="reassigned_count"># of Times Reassigned</th>
                        </tr>
                    </thead>
                </table>

            </div>
        </div>
    </div>
</div>
@stop
@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('reports.scripts.datatable-column-toggle-script');
@include('reports.use-tax.scripts.use-tax')
@stop