<script>

    $(document).ready(function () {

        var table = $('.footable').DataTable({
            fixedHeader:true,
			"scrollX": true,
			fixedColumns: true,
			fixedColumns: {
				left: 3
			},
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('upcoming-refresh-report-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "asset_tag" },
                { "data": "serial_number" },
                { "data": "type" },
                { "data": "manufacturer" },
                { "data": "hardware_standard" },
                { "data": "asset_status" },
                { "data": "user_location" },
                { "data": "department" },
                { "data": "work_location" },
                { "data": "age" },
                { "data": "depreciated_value" },
                { "data": "warranty_end_date" },
                { "data": "created_at" },
                { "data": "last_modified_date"},
                { "data": "last_modified_by"}
            ],
            lengthMenu: [
				[10, 25, 50, 100],
            	[10, 25, 50, 100]
			],
			iDisplayLength: 50,
            columnDefs: [
                { orderable: false, targets: "_all" }
            ],
            "aaSorting": [],
            "bAutoWidth": false,
            "bFilter": true,
            "searching": false,
            "fnDrawCallback": function (oSettings) {
                if (table.page.info().recordsTotal == 0) {
                    $("#export-csv").hide();
                } else {
                    $("#export-csv").show();
                }
            },
        });

        $('#search-form').submit(function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            table.draw();
            $('.ajax-loader').hide();
        });

        //Datatable column toggler
        $('span.col-toggle').on('click', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column($(this).attr('data-column'));

            // Toggle the visibility
            column.visible(!column.visible());
        });

        $("#asset_age").on('keyup change', function(){
            setTimeout(function() {
                $('#search-form').submit();
            }, 100 );
        });
    });

    $('#export-csv').on('click', function (e) {
        e.preventDefault();
        $('.ajax-loader').show();
        $.ajax({
            type: "POST",
            url: "{{ route('upcoming-refresh-export') }}",
            data: $('#search-form').serializeObject(),
            dataType: 'text',
            success: function (result) {
                var blob = new Blob([result]);
                var filename = "upcoming-refresh-report.csv"
                if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                    window.navigator.msSaveBlob(blob, filename);
                else {
                    var a = window.document.createElement("a");
                    a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                    a.download = filename;
                    document.body.appendChild(a);
                    a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                    document.body.removeChild(a);
                }
                $('.ajax-loader').hide();
            }
        })
    });

    $(".filter-field-user-department").each(function () {
        var name = $(this).attr('key');
        $(this).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
            url: '/get-filter-fields-user-department',
            dataType: "json",
            data: function (params) {
                var query = {
                search: params.term
                }

                // Query parameters will be ?search=[term]&type=public
                return query;
            },
            processResults: function (data) {
                // Tranforms the top-level key of the response object from 'items' to 'results'
                return {
                results: data
                };
            },

            }
        });
    });

</script>