
<div class="ibox">
    <div class="ibox-title">
        <div class="ibox-tools">
            <h5>Filters</h5>
            <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"
           ><i class="icon icon-e-delete"></i></a>
        </div>
    </div>
    <div class="collapse in" id="collapseFilter">
        <div class="ibox-content">
            <form method="post" id="search-form" action="">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Type</label>
                            <select class="form-control select2 filter" multiple name="asset_type" id="asset_type"
                            data-placeholder="Select">
                                @foreach(\App\Models\AssetType::whereIn('slug', config('reports.upcoming_refresh.include_asset_types'))->orderBy('name')->get() as $assetType)
                                <option value="{{$assetType->id}}">{{$assetType->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Manufacturer</label>
                            <select class="form-control select2 filter" multiple name="manufacturer"
                            id="manufacturer" data-placeholder="Select">
                                @foreach(\App\Models\Manufacturer::orderBy('name')->get() as $manufacturer)
                                <option value="{{$manufacturer->id}}">{{$manufacturer->name}}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Hardware Standard</label>
                            <select class="form-control select2 filter" multiple name="make_and_model" id="make_and_model" data-placeholder="Select">
                                @foreach(App\Models\MakeAndModel::valid()->orderBy('name', 'ASC')->get() as $hardware)
                                <option value="{{$hardware->id}}">{{ $hardware->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Status</label>
                            <select class="form-control select2 filter" multiple name="status" id="status"
                            data-placeholder="Select">
                                @foreach(\App\Models\AssetStatus::reportStatus()->orderBy('name')->get() as $status)
                                <option value="{{$status->id}}">{{$status->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Location</label>
                            <select class="filter-field-storage-location form-control filter" multiple name="location" id="location" key="room_name" data-placeholder="Select">
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">User Work Location</label>
                            <select class="filter-field-location form-control filter report-filter" multiple name="city"
                            key="city" id="work_location" data-placeholder="Select">
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Department</label>
                            <select class="form-control select2 filter-field-user-department" multiple name="department" id="department" data-placeholder="Select">
                                @foreach(\App\Models\Department::orderBy('name')->get() as $department)
                                <option value="{{$department->id}}" @if(is_array(request('department')) && in_array($department->id,request('department'))) selected="selected" @endif>{{$department->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Age of Asset in years (Older than)</label>
                            <select class="form-control select2 filter" name="asset_age" id="asset_age"
                            data-placeholder="Select">
                                <option value="2.5">2.5</option>
                                @for($i = 3; $i <= 6; $i++)
                                <option value="{{ $i }}">{{ $i }}</option>
                                @endfor
                                <option value="7">More than 6</option>
                            </select>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
