<script>

    $(document).ready(function () {

        var table = $('.footable').DataTable({
            fixedHeader:true,
			"scrollX": true,
			fixedColumns: true,
			fixedColumns: {
				left: 3
			},
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('unrepairable-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "asset_tag" },
                { "data": "serial_number" },
                { "data": "type" },
                { "data": "hardware_standard" },
                { "data": "tech_specs"},
                { "data": "asset_status" },
                { "data": "user_location" },
                { "data": "date_damaged" },
                { "data": "date_updated" },
                { "data": "days_to_review" },
                { "data": "age" },
                { "data": "depreciated_value" },
                { "data": "warranty_end_date" },
                { "data": "modified_date" },
                { "data": "modified_by" },
            ],
            lengthMenu: [
				[10, 25, 50, 100],
            	[10, 25, 50, 100]
			],
			iDisplayLength: 50,
            columnDefs: [
                { orderable: false, targets: "_all" }
            ],
            "aaSorting": [],
            "bAutoWidth": false,
            "bFilter": true,
            "searching": false,
            "fnDrawCallback": function (oSettings) {
                if (table.page.info().recordsTotal == 0) {
                    $("#export-csv").hide();
                } else {
                    $("#export-csv").show();
                }
            },
        });

        // Data table column toggle
        $(document).on('click', 'span.col-toggle', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column($(this).attr('data-column'));

            // Toggle the visibility
            column.visible(!column.visible());
        });

        $("#days_to_review").on('keyup', function (e) {
            e.preventDefault();
            $('#search-form').submit();
        })
        $('#search-form').submit(function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            table.draw();
            getWidgetCount();
            $('.ajax-loader').hide();
        });

        $('.input-daterange').datepicker({
            todayBtn:"linked",
            clearBtn:true,
            keyboardNavigation: false,
            forceParse: false,
            autoclose: true
        }).on('change',function(e){
            $('#search-form').submit();
        });

    });

    $('#export-csv').on('click', function (e) {
        e.preventDefault();
        $('.ajax-loader').show();
        $.ajax({
            type: "POST",
            url: "{{ route('unrepairable-export') }}",
            data: $('#search-form').serializeObject(),
            dataType: 'text',
            success: function (result) {
                var blob = new Blob([result]);
                var filename = "unrepairable-report.csv"
                if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                    window.navigator.msSaveBlob(blob, filename);
                else {
                    var a = window.document.createElement("a");
                    a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                    a.download = filename;
                    document.body.appendChild(a);
                    a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                    document.body.removeChild(a);
                }
                $('.ajax-loader').hide();
            }
        })
    });

    function getWidgetCount()
    {
        $.ajax({
            type: "POST",
            url: "{{ route('unrepairable-widget-count') }}",
            data: $('#search-form').serializeObject(),
            dataType: 'json',
            success: function (result) {
                $("#assets_count").text(result.assets)
                $("#assets_unrepaired").text(result.assets_unrepaired)
                $("#assets_value").text(result.assets_value)
                $("#assets_under_warranty").text(result.assets_under_warranty)
                $("#average_days_to_repair").text(result.average_days_to_repair)
            }
        })
    }

</script>