@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Unrepairable Assets','parentUrl' => '/report', 'parentTitle' =>
'Reports'])
<div class="wrapper-content">
    <div class="container-fluid">

        @include('reports.unrepairable.partials.filter')
        @include('reports.unrepairable.partials.widgets')

        <div class="ibox">

            <div class="ibox-title">
                <div class="ibox-tools">
                    <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                </div>
            </div>

            <div class="ibox-content">
                @include('partials.success')
                @include('partials.error-message')
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

                <div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
				</div>

                <table class="footable table table-stripped table-hover nowrap three-col-fixed has-column-toggler" data-page-size="50" data-filter=#filter>

                    <thead>

                        <tr>

                            <th>#</th>
                            <th>Asset Tag #</th>
                            <th>Serial #</th>
                            <th class="sort-alpha">Asset Type</th>
                            <th>Hardware Standard</th>
                            <th>Technical Specs</th>
                            <th>Asset Status </th>
                            <th>User/Location</th>
                            <th>Date Damaged</th>
                            <th>Date Updated</th>
                            <th>Days to Review</th>
                            <th>Asset Age</th>
                            <th>Depreciated Value</th>
                            <th>Warranty End Date</th>
                            <th>Last Modified Date</th>
                            <th>Last Modified By</th>
                        </tr>

                    </thead>

                </table>

            </div>

        </div>



    </div>

</div>
@stop

@section('after_scripts')

@include('reports.scripts.common')
@include('reports.scripts.datatable-column-toggle-script')
@include('reports.scripts.filter-options-with-ajax')
@include('reports.unrepairable.scripts.script')
@include('assets.partials.scripts.dropdown-script')


@stop

@section('help')
@include('help.users')
@endsection