<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/select2/select2.full.min.js"></script>
<script src="/js/sweetalert2.all.min.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedColumns.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">


<script>
	
	$(document).ready(function () {
		
		@if (count($errors) > 0)
		$('#email-share').modal('show');
		@endif
		
		$('.footer').css('position', 'fixed');
		
		$.fn.serializeObject = function () {
			var obj = {};
			
			$.each(this.serializeArray(), function (i, o) {
				var n = o.name, v = o.value;
				
				obj[n] = obj[n] === undefined ? v
				: $.isArray(obj[n]) ? obj[n].concat(v)
				: [obj[n], v];
			});
			
			return obj;
		};
		
		var table = $('.footable').DataTable({
			fixedHeader:true,
			"scrollX": true,
			scrollY: '400px',
            scrollCollapse: true,
			fixedColumns: true,
			fixedColumns: {
				left: 3
			},
			"processing": true,
			"serverSide": true,
			"ajax": {
				"url": "{{ route('reports-generator-data') }}",
				"dataType": "json",
				"type": "POST",
				"data": function (result) {
					result.form = $('#asset-filter-form').serializeObject();
				}
			},
			"columns": [
			{ "data": "id" },
			{ "data": "asset_tag" },
			{ "data": "serial_number" },
			{ "data": "type" },
			{ "data": "manufacturer" },
			{ "data": "child_asset" },
			{ "data": "hardware_standard" },
			{ "data": "technical_spec" },
			{ "data": "po_number" },
			{ "data": "vendor" },
			{ "data": "asset_status" },
			{ "data": "lock_status" },
			{ "data": "user_location" },
			{ "data": "email" },
			{ "data": "employee_id" },
			{ "data": "business_title" },
			{ "data": "department" },
			{ "data": "work_location" },
			{ "data": "legal_hold" },
			{ "data": "hire_date" },
			{ "data": "terminated_date" },
			{ "data": "status" },
			{ "data": "lease_end_date" },
			{ "data": "loaner_return_date" },
			{ "data": "carrier" },
			{ "data": "ewaste_certificate" },
			{ "data": "age" },
			{ "data": "original_value" },
			{ "data": "deprecated_value" },
			{ "data": "warranty_end_date" },
			{ "data": "modified_date" },
			{ "data": "modified_by" },
			],
			lengthMenu: [
			[50, 100, 200],
			['50', '100', '200']
			],
			"fnDrawCallback": function (oSettings) {
				if (table.page.info().recordsTotal == 0) {
					$("#export-csv").hide();
				} else {
					$("#export-csv").show();
				}
			},
			
		});
		
		$('.chosen-select').chosen({ width: "100%" });
		
		$('.select2').select2();
		
		$('#data_1 .input-group.date').datepicker({
			
			todayBtn: "linked",
			
			clearBtn: true,
			
			keyboardNavigation: false,
			
			forceParse: false,
			
			calendarWeeks: false,
			
			autoclose: true
			
		});
		
		$('#export-csv').on('click', function (e) {
			e.preventDefault();
			$('.ajax-loader').show();
			$(".sync-msg").hide();
			$.ajax({
				type: "POST",
				url: "/report/generator-export",
				data: $('#asset-filter-form').serializeObject(),
				dataType: 'text',
				success: function (result) {
					var checkPortion = 'Your report will be generated in the background.';
					if (checkPortion == result.substring(0, 48)) {
						$("#sync-success-msg").html(result);
						$("#sync-success").show();
						$('.ajax-loader').hide();
					} else {
						var blob = new Blob([result]);
						if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
						window.navigator.msSaveBlob(blob, "asset.csv");
						else {
							var a = window.document.createElement("a");
							a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
							a.download = "asset.csv";
							document.body.appendChild(a);
							a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
							document.body.removeChild(a);
						}
						$('.ajax-loader').hide();
					}
				}
			}).fail(function() {
				$("#sync-error-msg").html("Some error occurred.");
				$("#sync-error").show();
				$('.ajax-loader').hide();
			});
		});
		
		$('.fa-arrows-h').on('click', function (e) {
			e.preventDefault();
			var column = table.column($(this).attr('data-column'));
			
			// Toggle the visibility
			column.visible(!column.visible());
		});
		
		$('#save_search').on('click', function (e) {
			
			e.preventDefault();
			var formData = $('#asset-filter-form').serializeObject();
			
			var report_name = $("#name").val();
			var view_all = $('#view_all').val() ? ($('#view_all').prop('checked') == true ? 1 : '') : '';
			
			formData = {name: report_name,view_all:view_all,...formData};
			
			
			$.ajax({
				type: "POST",
				url: "/report/generator",
				data: formData,
				success: function (result) {
					if (result.status=='success'){
						$('.alert').hide();
						$('#success').show();
						$('#success p').text(result.message);
						if(view_all) {
							$("#adminSavedSearch").append(result.dropdown);
						}else{
							$("#userSavedSearch").append(result.dropdown);
						}
					}else{
						$('#error').show();
						$('#error p').text(result.message);
					}
				}
			}).done(function () {
				$('html, body').animate({
					scrollTop: $("#error").offset().top
				}, 1000);
			});
			
		});
		
		$('#update_search').on('click', function (e) {
			
			e.preventDefault();
			$('.ajax-loader').show();
			var formData = $('#asset-filter-form').serializeObject();
			
			var report_name = $("#name").val();
			var view_all = $('#view_all').val() ? ($('#view_all').prop('checked') == true ? 1 : '') : '';
			var report_id = $('#report_id').val();
			
			formData = {report_id: report_id,name: report_name,view_all:view_all,...formData};
			
			$.ajax({
				type: "POST",
				url: "/report/generator-update",
				data: formData,
				success: function (data) {
					if(data.status=='error'){
						$('#error').show();
						$('#error p').text(data.message);
					}else{
						if(data.url) {
							location.href = "/report/generator"+data.url;
						}else{
							location.reload();
						}
					}
				}
			});
			
		});
		
		$('#delete_search').on('click', function (e) {
			e.preventDefault();
			Swal.fire({
				title: 'Are you sure?',
				text: "You won't be able to revert this!",
				icon: 'warning',
				showCancelButton: true,
				confirmButtonColor: '#3085d6',
				cancelButtonColor: '#d33',
				confirmButtonText: 'Yes, delete search!'
			}).then((result) => {
				if (result.isConfirmed) {
					$('.ajax-loader').show();
					
					$.ajax({
						type: "POST",
						url: "/report/generator-delete",
						data: {report_id: $('#report_id').val()},
						success: function (value) {
							
						}
					}).done(function () {
						location.href = "/report/generator";
					});
				}
			})
		});
		
		$('#asset-filter-form').submit(function (e) {
			
			e.preventDefault();
			$('.ajax-loader').show();
			table.draw();
			$('.ajax-loader').hide();
			
		});
		
		$(".filter-field").each(function () {
			var name = $(this).attr('key');
			$(this).select2({
				minimumInputLength: 1,
				multiple: true,
				ajax: {
					url: '/get-filter-fields',
					dataType: "json",
					data: function (params) {
						var query = {
							search: params.term,
							type: name
						}
						
						// Query parameters will be ?search=[term]&type=public
						return query;
					},
					processResults: function (data) {
						// Tranforms the top-level key of the response object from 'items' to 'results'
						return {
							results: data
						};
					},
					
				}
			});
		});
		
		$(".filter-field-user").each(function () {
			$(this).select2({
				minimumInputLength: 1,
				multiple: true,
				ajax: {
					url: '/get-filter-fields-all-user',
					dataType: "json",
					data: function (params) {
						var query = {
							search: params.term
						}
						
						// Query parameters will be ?search=[term]&type=public
						return query;
					},
					processResults: function (data) {
						// Tranforms the top-level key of the response object from 'items' to 'results'
						return {
							results: data
						};
					},
					
				}
			});
		});
		
		$(".filter-field-location").each(function () {
			var name = $(this).attr('key');
			$(this).select2({
				minimumInputLength: 1,
				multiple: true,
				ajax: {
					url: '/get-filter-fields-location',
					dataType: "json",
					data: function (params) {
						var query = {
							search: params.term,
							type: name
						}
						
						// Query parameters will be ?search=[term]&type=public
						return query;
					},
					processResults: function (data) {
						// Tranforms the top-level key of the response object from 'items' to 'results'
						return {
							results: data
						};
					},
					
				}
			});
		});
		//Datatable column toggler
		$(document).on('click', 'span.col-toggle', function (e) {
			e.preventDefault();
			$(this).toggleClass('col-hidden');
			// Get the column API object
			var column = table.column($(this).attr('data-column'));
			
			// Toggle the visibility
			column.visible(!column.visible());
		});
		
	});
	
</script>