<script>
$(document).ready(function() {
    $('.chosen-select').chosen({width: "100%"}).change(function() {
        $(this).closest('.form-group').next().find('input').focus();
    });

    $(".filter-field").each(function() {
        var name = $(this).attr('key');
        $( this ).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '/get-filter-fields',
                dataType: "json",
                data: function (params){
                    var query = {
                    search: params.term,
                    type: name
                    }

                    // Query parameters will be ?search=[term]&type=public
                    return query;
                },
                processResults: function (data) {
                    // Tranforms the top-level key of the response object from 'items' to 'results'
                    return {
                    results: data
                    };
                },

            }
        });
    });

    $(".filter-field-user").each(function() {
        $( this ).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '/get-filter-fields-user',
                dataType: "json",
                data: function (params){
                    var query = {
                    search: params.term
                    }

                    // Query parameters will be ?search=[term]&type=public
                    return query;
                },
                processResults: function (data) {
                    // Tranforms the top-level key of the response object from 'items' to 'results'
                    return {
                    results: data
                    };
                },

            }
        });
    });

    $(".filter-location").each(function() {
        let type = $(this).attr('key');
        $( this ).select2({
            minimumInputLength: 1,
            multiple: true,
            tokenizer: function (input, s2, callback) {
                var term = input.term;
                if (term.indexOf(';') < 0)
                    return input; // Exit if no tokens

                var parts = term.split(";");
                for (var i = 0; i < parts.length; i++) {
                    var part = parts[i].trim();
                    if (part.length > 2) {
                        $.ajax({
                            url: s2.options.ajax.url,
                            dataType: s2.options.ajax.dataType,
                            data: s2.options.ajax.data({ term: part }),
                            async: false, // If async then unable to return unmatched tokens
                            success: function (data) {
                                var pr = s2.options.ajax.processResults(data, { term: part });
                                callback(pr.results[0]);
                                parts.splice(i--, 1);
                            }
                        });
                    }
                }
                return { term: parts.join(';') }; // Rejoin unmatched tokens
            },
            ajax: {
                url: '/get-filter-fields-location',
                dataType: "json",
                data: function (params){
                    var query = {
                        search: params.term,
                        type: type
                    }

                    // Query parameters will be ?search=[term]&type=public
                    return query;
                },
                processResults: function (data) {
                    // Tranforms the top-level key of the response object from 'items' to 'results'
                    return {
                    results: data
                    };
                },

            }
        });
    });

    var delay = (function(){
        var timer = 0;
        return function(callback, ms){
            clearTimeout (timer);
            timer = setTimeout(callback, ms);
        };
    })();

    $("#search-form select").on('change', function(){
        $('#search-form').submit();
    });

    $("#search-form input").on('keyup', function(){
        $('#search-form').submit();
    });

});
</script>