<div class="ibox">
    <div class="ibox-title">
        <div class="ibox-tools">
            <h5>Filters</h5>
            <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
        </div>
    </div>
    <div class="collapse in" id="collapseFilter" aria-expanded="true">
        <div class="ibox-content">
            <form method="post" id="search-form" action="">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Tag #</label>
                            <select class="filter-field form-control" id="asset_tag" multiple name="asset_tag"data-placeholder="Select" key="asset_tag">
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Type </label>
                            <select class="chosen-select" id="asset_type" multiple name="asset_type" data-placeholder="Select">
                            @foreach(\App\Models\AssetType::valid()->orderBy('name', 'ASC')->get() as $assetType)
                                <option value="{{$assetType->id}}">{{$assetType->name}}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Hardware Standard</label>
                            <select class="form-control select2" multiple name="make_and_model" id="make_and_model" data-placeholder="Select">
                            @foreach(\App\Models\MakeAndModel::valid()->orderBy('name', 'ASC')->get() as $hardware)
                                <option value="{{$hardware->id}}">{{ $hardware->name }}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Technical Specs</label>
                            <select class="form-control select2" multiple name="technical_spec" id="technical_spec" data-placeholder="Select">
                            @foreach(\App\Models\TechnicalSpecs::valid()->orderBy('details', 'ASC')->get() as $technicalSpec)
                                <option value="{{$technicalSpec->id}}">{{ $technicalSpec->details}}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>

                </div>
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Status</label>
                            <select class="chosen-select" multiple name="status" id="status" data-placeholder="Select">
                            @foreach(\App\Models\AssetStatus::reportStatus()->orderBy('name', 'ASC')->get() as $status)
                                <option value="{{$status->id}}">{{$status->name}}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label"># of Times Reused</label>
                            <input type="number" name="no_of_times" placeholder="# of Times Reused" class="form-control" id="no_of_times">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">User</label>
                            <select class="filter-field-user select2 form-control filter-input" multiple name="user" id="user" key="user" data-placeholder="Select">
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Location </label>
                            <select class="filter-location form-control" multiple name="location" id="location" key="room_name" data-placeholder="Select">
                            </select>
                        </div>
                    </div>

                </div>

            </form>
        </div>
    </div>
</div>