
<div class="ibox">
    <div class="ibox-title">
        <div class="ibox-tools">
            <h5>Filters</h5>
            <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"
           ><i class="icon icon-e-delete"></i></a>
        </div>
    </div>
    <div class="collapse in" id="collapseFilter">
        <div class="ibox-content">
            <form method="post" id="search-form" action="">
                {{ csrf_field() }}
                <input type="hidden" name="type" value="{{ request()->has('type') ? request('type') : '' }}">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Type</label>
                            <select class="form-control select2 filter" multiple name="asset_type" id="asset_type"
                            data-placeholder="Select">
                                @foreach(\App\Models\AssetType::valid()->orderBy('name', 'ASC')->get() as $assetType)
                                <option value="{{$assetType->id}}" @if(request()->has('asset_type') && in_array($assetType->id, request('asset_type'))) selected @endif>{{$assetType->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Manufacturer</label>
                            <select class="form-control select2 filter" multiple name="manufacturer" id="manufacturer" data-placeholder="Select">
                                @foreach(\App\Models\Manufacturer::orderBy('name', 'ASC')->get() as $manufacturer)
                                <option value="{{$manufacturer->id}}" @if(request()->has('manufacturer') && in_array($manufacturer->id, request('manufacturer'))) selected @endif>{{$manufacturer->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Hardware Standard</label>
                            <select class="form-control select2 filter" multiple name="make_and_model"
                            id="make_and_model" data-placeholder="Select">
                                @foreach(Facades\App\Models\MakeAndModel::valid()->orderBy('name', 'ASC')->get() as $hardware)
                                <option value="{{$hardware->id}}" @if(request()->has('make_and_model') && in_array($hardware->id, request('make_and_model'))) selected @endif>{{ $hardware->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Status</label>
                            <select class="form-control select2 filter" multiple name="status" id="status"
                            data-placeholder="Select">
                                @foreach(\App\Models\AssetStatus::whereIn('slug', config('reports.repair_and_recovery.include_statuses'))->orderBy('name')->get() as $status)
                                <option value="{{$status->id}}" @if(request()->has('status') && in_array($status->id, request('status'))) selected @endif>{{$status->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Location</label>
                            <select class="filter-field-storage-location form-control filter" multiple name="location" id="location" key="room_name" data-placeholder="Select">
                            @if(request()->has('location'))
                                @foreach(\App\Models\Location::whereIn('id', request('location'))->get() as $location)
                                    <option value="{{$location->id}}" selected="selected">{{$location->room_name}}</option>
                                @endforeach
                            @endif
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Last Modified Date Range</label>
                            <div class="form-group">
                                <div class="input-group date">
                                    <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                    <input type="text" name="date_from" value="{{ $dateFrom ?? request('date_from') }}" class="form-control readonly-white active-user-filter" id="date_from" placeholder="From" autocomplete="off" readonly>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="input-group date">
                                    <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                    <input type="text" class="form-control readonly-white active-user-filter" placeholder="To" name="date_to" value="{{ $dateTo ?? request('date_to') }}" id="date_to" autocomplete="off" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
