
<div class="ibox">
    <div class="ibox-title">
        <div class="ibox-tools">
            <h5>Saved Searches</h5>
            <a data-toggle="collapse" href="#collapseSavedSearch" class="collapse-link">
                <i class="icon icon-e-add"></i></a>
        </div>
    </div>
    <div class="collapse" id="collapseSavedSearch">
        <div class="ibox-content">

            @php
            // Get the current URL
            $currentUrl = url()->current();
            // Extract the URL before the query string
            $urlBeforeQuery = strtok($currentUrl, '?');
            @endphp
            
            <div class="row">
                <form method="get" class="saved-search-form" action="">
                    <div class="col-sm-6">

                        <label>Admin Saved Searches</label>
                        <div class="row">
                            <div class="col-sm-8">
                                <div class="form-group">
                                    <select class="form-control select2" name="admin_saved_search" id="adminSavedSearch" data-placeholder="Select">
                                        <option value="">Select</option>
                                        @foreach($viewAllFilters as $report)
                                        <option value="{{$report->id}}" {{request('admin_saved_search') ? ($report->
                                            id == request('admin_saved_search') ? 'selected' : '') : ''}}>
                                            {{$report->name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <button type="submit" class="btn btn-primary search_saved">Search</button>
                                <a href="{{ $urlBeforeQuery }}" class="btn btn-primary">Clear</a>
                            </div>
                        </div>
                    </div>
                </form>
                <form method="get" class="saved-search-form" action="">
                    <div class="col-sm-6 space-15-xs-b p-0">

                        <label>User Saved Searches</label>
                        <div class="row">
                            <div class="col-sm-8">
                                <div class="form-group">
                                    <select class="form-control select2" name="user_saved_search" id="userSavedSearch" data-placeholder="Select">
                                        <option value="">Select</option>
                                        @foreach($savedFilters as $report)
                                        <option value="{{$report->id}}" {{request('user_saved_search') ? ($report->
                                            id ==
                                            request('user_saved_search') ? 'selected' : '') : ''}}>
                                            {{$report->name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <button type="submit" class="btn btn-primary search_saved">Search</button>
                                <a href="{{ $urlBeforeQuery }}" class="btn btn-primary">Clear</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <hr>

            <div class="row">
                {{csrf_field()}}
                @if(($user->userType->name == 'Administrator') || ($user->userType->name == 'Super Admin'))
                <div class="col-sm-6 col-md-12">
                    <div class="form-group">
                        <br>
                        <label><input type="checkbox" id="view_all" name="view_all" value="1" {{$savedSearch ?
                                ($savedSearch->view_all == 1 ? 'checked' : '') : ''}}> Visible to All</label>
                    </div>
                </div>
                @endif

                <div class="col-sm-4 col-md-3">
                    <label class="control-label">Search Name</label>
                    <input type="text" name="name" id="name" class="form-control"
                        value="{{$savedSearch ? $savedSearch->name : ''}}">
                </div>
                <div class="col-sm-2 col-md-2">
                    <button type="submit" class="btn btn-primary btn-block filter-button" id="save_search">
                        Save Search
                    </button>
                </div>

                @if($savedSearch)
                @if($savedSearch->user_id == $user->id)
                <div class="col-md-2">
                    <input type="hidden" name="report_id" id="report_id" value="{{$savedSearch->id}}">
                    <button type="submit" class="btn btn-primary btn-block filter-button"
                        id="update_search">Update Search
                    </button>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary btn-block filter-button"
                        id="delete_search">Delete Search
                    </button>
                </div>
                @endif
                @endif
            </div>

        </div>
    </div>
</div>
