@forelse($assets as $asset)

<tr>
	<td>{{$loop->index+1}}</td>
	<td>{{$asset->assetType->name ?? ''}}</td>
	<td>{{$asset->po_id}}</td>
	<td><a href="{{route('assets.show', $asset->id)}}">{{$asset->asset_tag}}</a></td>
	<td>{{$asset->serial_no}}</td>
	<td>{{$asset->makeAndModel->manufacturer->name ?? ''}} {{$asset->makeAndModel->name ?? ''}}</td>
	<td>{{$asset->technicalSpec->details ?? ''}}</td>
	<td>{{$asset->assetStatus->name ?? ''}}</td>
	<td>{{$asset->imei}}</td>
	<td>{{$asset->user ? ($asset->user->userName) : ($asset->location ? $asset->location->room_name : '')}}</td>
	<td>{{$asset->date_deployed}}</td>
	<td>{{$asset->lease_start_date}}</td>
	<td>{{$asset->lease_end_date}}</td>
	<td>{{$asset->loaner_return_date}}</td>
	<td>{{$asset->loaner_retention_date}}</td>
	<td>{{$asset->ticket_no}}</td>
	<td>{{$asset->carrier->name ?? ''}}</td>
	<td>{{$asset->parentAsset->asset_tag ?? ''}}</td>
	<td>{{$asset->linked_date}}</td>
	<td>{{$asset->lost_date}}</td>
	<td>{{$asset->end_of_life_date}}</td>
	<td>{{$asset->wipe_confirmation}}</td>
	<td>@if($asset->ewaste_certificate)
		{{route('downloadcertificate', ['file' => str_replace('/', '-', $asset->ewaste_certificate)])}}
		@endif
	</td>
	<td>{{$asset->AssetAge}}</td>
	<td>{{$asset->latestAssetHistory->updated_at ?? ''}}</td>
	<td>{{$asset->latestAssetHistory->user->userName ?? ''}}</td>
	<td>{{$asset->created_at}}</td>
</tr>
@empty
<tr>
	<td>No assets.</td>
</tr>
@endforelse