@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Android', 'parentUrl' => '/report', 'parentTitle' => 'Reports', 'parentSubUrl' => route('apple-compliance-report'), 'parentSubTitle' => 'Operating System Compliance Reports'])
@include('reports.os-compliance.submenu')
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            @include('reports.os-compliance.filters.android-filters')
        </div>

        <div class="ibox">

            <div class="ibox-title">

                <div class="ibox-tools">
                    <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>

                </div>

            </div>

            <div class="ibox-content">

                @include('partials.success')

                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

                <div class="table-responsive">
                    <div class="dt-coltoggler-wrapper ">
                        <p>Click to toggle table columns: </p>
                    </div>
                    <table class="footable table table-stripped table-hover nowrap two-col-fixed has-column-toggler" id="table-report-generator" data-page-length="50" data-searching="false" data-ordering="false">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Serial # </th>
                                <th>Serial # ({{config('os-compliance.android_os.mdm')}})</th>
                                <th class="sort-alpha">Asset Type</th>
                                <th>Hardware Standard ({{config('os-compliance.android_os.mdm')}})</th>
                                <th>Hardware Standard (Teqtivity)</th>
                                <th>Technical Specs </th>
                                <th>Asset Status </th>
                                <th>User/Location</th>
                                <th>User ({{config('os-compliance.android_os.mdm')}})</th>
                                <th>OS Platform ({{config('os-compliance.android_os.mdm')}})</th>
                                <th>OS Version ({{config('os-compliance.android_os.mdm')}})</th>
                                <th>Latest Version </th>
                                <th>Last Check In </th>

                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.asset_reports'),'helpTitle'=>config('help-links.help_titles.asset_reports')])
@endsection

@section('after_scripts')
@include('reports.scripts.filter-options-with-ajax')
@include('reports.os-compliance.script.android-script')
@include('reports.scripts.datatable-column-toggle-script');
@stop