<script>
    $(document).ready(function() {
        var table = $('.footable').DataTable({
            fixedHeader: {
                header: true,
            },
            fixedColumns: true,
			fixedColumns: {
				left: 3
			},
			"scrollX": true,
            "processing": true,
            "serverSide": true,
            "ajax":{
                "url": "{{ route('on-hand-asset-age-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "asset_tag" },
                { "data": "serial_no" },
                { "data": "asset_type" },
                { "data": "hardware_standard" },
                { "data": "tech_specs" },
                { "data": "location" },
                { "data": "asset_status" },
                { "data": "asset_age" },
                { "data": "created_at"}
            ],
            lengthMenu: [
				[10, 25, 50, 100],
            	[10, 25, 50, 100]
			],
			iDisplayLength: 50,
            'ordering': false,
            "aaSorting": [],
            "bAutoWidth": false,
            "bFilter": true,
            "searching": false,
        });

        // Data table column toggle
        $('span.col-toggle').on('click', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column($(this).attr('data-column'));

            // Toggle the visibility
            column.visible(!column.visible());
        });

        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "/inventory-control/on-hand-asset-age-export",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    var filename = "on-hand-asset-age-assets-report.csv"
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, filename);
                    else
                    {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });

        $("#search-form input").on('keyup', function(){
          $('#search-form').submit();
        });
        $("#search-form input").on('change', function(){
          $('#search-form').submit();
        });
        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });
    });


</script>