@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'On Hand Asset Age', 'parentUrl' => '#', 'parentTitle' => 'Inventory Control'])
<div class="wrapper-content">
    <div class="container-fluid ">
        <div class="row">
            @include('reports.on-hand-asset-age.partials.filter')
            <div class="col-lg-12">
                <div class="ibox">

                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <button type="button" id="export-csv" class="btn btn-primary">Export to CSV</button>
                        </div>
                    </div>

                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <div class="dt-coltoggler-wrapper ">
                            <p>Click to toggle table columns: </p>
                        </div>
                        <table class="footable table table-stripped table-hover nowrap three-col-fixed has-column-toggler" data-page-size="50" data-filter=#filter id="OnHandAssetAgeTable">

                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Asset Tag #</th>

                                    <th>Serial #</th>

                                    <th>Asset Type</th>

                                    <th>Hardware Standard</th>

                                    <th>Technical Specs</th>

                                    <th>Location</th>

                                    <th>Asset Status</th>

                                    <th>Asset Age</th>

                                    <th>Date Created</th>

                                </tr>

                            </thead>

                            <tbody>


                            </tbody>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
@stop
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.on_hand_asset_age'),'helpTitle'=>config('help-links.help_titles.on_hand_asset_age')])
@endsection

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.filter-options-with-ajax')
@include('reports.scripts.datatable-column-toggle-script');
@include('reports.on-hand-asset-age.scripts.script')

@stop