<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/sweetalert2.all.min.js"></script>
<script>
    $(document).ready(function () {
        $('.chosen-select').chosen({
            width: "100%"
        }).change(function () {
            $(this).closest('.form-group').next().find('input').focus();
        });

        $.fn.serializeObject = function () {
            var obj = {};

            $.each(this.serializeArray(), function (i, o) {
                var n = o.name,
                    v = o.value;

                obj[n] = obj[n] === undefined ? v :
                    $.isArray(obj[n]) ? obj[n].concat(v) :
                        [obj[n], v];
            });

            return obj;
        };




        $('#viewAssetModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('asset-id');
            $.ajax({
                type: "POST",
                url: "new-hire/get-assets/" + id,
                success: function (value) {
                    $('#asset-table-body').html(value);
                }
            });
        });

        var table = $('.footable').DataTable({
            paging: true,
            pageLength: 100,
            lengthMenu: [[20, 50, 100, 200], [20, 50, 100, 200]],
            scrollX: true, // Set this to true if you want horizontal scrolling
            scrollY: '400px',
            scrollCollapse: true,
            columnDefs: [
                { orderable: false, targets: 1 },
                { width: "5%", orderable: false, targets: 'all' }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('new-hire-data') }}",
                dataType: "json",
                type: "POST",
                data: function (result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            fnDrawCallback: function () {
                $('[data-tooltip="tooltip"]').tooltip({
                    container: "body"
                });
            },
            "columns": [{
                "data": "id"
            },
            {
                "data": "first_name"
            },
            {
                "data": "last_name"
            },
            {
                "data": "email"
            },
            {
                "data": "title"
            },
            {
                "data": "employee_type"
            },
            {
                "data": "start_date"
            },
            {
                "data": "department"
            },
            {
                "data": "location"
            },
            {
                "data": "modified_date"
            },
            {
                "data": "modified_by"
            },
            {
                "data": "no_of_assets"
            },
            {
                "data": "ticket_no"
            },
            {
                "data": "ticket_status"
            },
            {
                "data": "tracking_number"
            },
            {
                "data": "shipment_status"
            },
            {
                "data": "action_buttons"
            },

            ],
            dom: '<"top"i>rt<"bottom"flp><"clear">',
            bAutoWidth: false,
            bFilter: true,
            bLengthChange: true,
            searching: false,
            initComplete: function (settings, json) {
                $('.dataTables_scrollBody').on('scroll', function () {
                    $('.dataTables_scrollHeadInner').scrollLeft($(this).scrollLeft());
                });

                $(document).on('scroll', function () {
                    // Your scroll-related code
                });
            },
            fixedHeader: {
                header: true,
            },
            drawCallback: function () {
                $(".filter-field").each(function () {
                    var name = $(this).attr('key');
                    $(this).select2({
                        minimumInputLength: 1,
                        multiple: false,
                        ajax: {
                            url: '/get-filter-fields',
                            dataType: "json",
                            data: function (params) {
                                var query = {
                                    search: params.term,
                                    type: name
                                }
                                // Query parameters will be ?search=[term]&type=public
                                return query;
                            },
                            processResults: function (data) {
                                // Transforms the top-level key of the response object from 'items' to 'results'
                                return {
                                    results: data
                                };
                            },

                        }
                    });
                });
            },
            fnDrawCallback: function(oSettings) {
                if (oSettings._iRecordsDisplay == 0) {
                    $("#export-user-csv").hide();
                } else {
                    $("#export-user-csv").show();
                }
            }
        });
        // table.columns.adjust().draw();

        var delay = (function () {
            var timer = 0;
            return function (callback, ms) {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            };
        })();


        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $("#employee_type, #fte, #work_location, #department").on('change', function () {
            $('#search-form').submit();
        });

        $('#no_of_assets').on('keyup change', function () {
            $('#search-form').submit();
        });

        $("#employee_name").on('keyup change', function () {
            delay(function () {
                $('#search-form').submit();
            }, 200);
        });

        $('#date_from').datepicker().on('change', function (e) {
            $('#search-form').submit();
        });

        $('#date_to').datepicker().on('change', function (e) {
            $('#search-form').submit();
        });
        $('#data_1 .input-group.date').datepicker({

            todayBtn: "linked",

            clearBtn: true,

            keyboardNavigation: false,

            forceParse: false,

            calendarWeeks: false,

            autoclose: true

        });

        $('#save_search').on('click', function (e) {

            e.preventDefault();
            var formData = $('#search-form').serializeObject();
            var view_all = $('#view_all').val() ? ($('#view_all').prop('checked') == true ? 1 : '') : '';
            formData = { ...formData, name: $('#name').val(), view_all: view_all }; //Adding report name and view all inputs to formdata
            $.ajax({
                type: "POST",
                url: "/new-hire/save-search",
                data: formData,
                success: function (result) {
                    if (result.status=='success'){
                        $('.alert').hide();
                        $('#success').show();
                        $('#success p').text(result.message);
                        if(view_all) {
                            $("#adminSavedSearch").append(result.dropdown);
                        }else{
                            $("#userSavedSearch").append(result.dropdown);
                        }
                    }else{
                        $('#error').show();
                        $('#error p').text(result.message);
                    }
                }
            }).done(function () {
                $('html, body').animate({
                    scrollTop: $("#error").offset().top
                }, 1000);
            });

        });

        $('#update_search').on('click', function (e) {

            e.preventDefault();
            $('.ajax-loader').show();
            var formData = $('#search-form').serializeObject();
            var view_all = $('#view_all').val() ? ($('#view_all').prop('checked') == true ? 1 : '') : '';
            formData = { ...formData, report_id: $('#report_id').val(), name: $('#name').val(), view_all: view_all }; //Adding report name and view all inputs to formdata

            $.ajax({
                type: "POST",
                url: "/new-hire/update-save-search",
                data: formData,
                success: function (data) {
                    if(data.status=='error'){
                        $('#error').show();
                        $('#error p').text(data.message);
                    }else{
                        if(data.url) {
                            location.href = "/new-hire"+data.url;
                        }else{
                            location.reload();
                        }
                    }
                }
            });

        });

        $('#delete_search').on('click', function (e) {
            e.preventDefault();
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete search!'
			}).then((result) => {
				if (result.isConfirmed) {

                    $('.ajax-loader').show();

                    $.ajax({
                        type: "POST",
                        url: "/new-hire/delete-save-search",
                        data: { report_id: $('#report_id').val() },
                        success: function (value) {
                        }
                    }).done(function () {
                        location.href = "/new-hire";
                    });
                }
            });

        });

        $('#export-user-csv').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "/new-hire/new-hire-export",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function (result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob) // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, "new-hire-employees.csv");
                    else {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {
                            type: "text/plain"
                        });
                        a.download = "new-hire-employees.csv";
                        document.body.appendChild(a);
                        a.click(); // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });


        $(document).on("click", ".assign-asset", function (e) {

            // $("select[name=asset_id]").val('');
            $('#asset_id').val('').trigger('chosen:updated');
            $('.errorText').text('');
            $('#assigned').modal('show');
            $('#assigned').find('select').next().addClass('chosen-with-drop').find('input').focus();
            var userId = $(this).attr('data-user');
            $('#assigned').find('#user_id').val(userId);
            $('#modal_ticket_no').val($(this).attr('data-ticket'));

        });

        $('.assign-asset').each(function () {
            $(this).ajaxChosen({
                dataType: 'json',
            }, {
                processItems: function (data) { return data },
                generateUrl: function (q) { return '/get-filter-fields-assign-assets?search=' + q; },
            },
                {
                    width: "100%"
                }).change(function () {
                    $(this).closest('.form-group').next().find('input').focus();
                });
        });

        $(document).on("click", ".cancel-assign-asset", function (e) {
            $(this).parent().parent().find('.assign-asset-form').hide();
            $(this).parent().parent().find('.assign-asset').show();
        });

        $("#search-asset-assigned-form").validate({
            ignore: ":hidden:not(select)",
            rules: {
                asset_id: {
                    required: true,
                    number: true
                },
                status_id: {
                    required: true,
                    number: true
                },
                user_id: {
                    required: true,
                    number: true
                }
            },
            messages: {
                'asset_id': { required: 'Please select an Asset' },
                'asset_id': { number: 'Invalid Asset Selected' },
            },
            errorPlacement: function (error, element) {
                // console.log(element);
                if (element.is("select#asset_id")) {
                    // placement for chosen
                    $('#asset_id_chosen').removeClass('chosen-container-active').removeClass('chosen-with-drop');
                    error.insertAfter($(element).next($('.errorText')));
                } else {
                    // standard placement
                    error.insertAfter(element);
                }
            }

        });

        $("#asset-assigned-submit").on('click', function () {
            if ($('#search-asset-assigned-form').valid()) {
                $('#search-asset-assigned-form').submit();
            } else {
            }
            // $('#search-asset-assigned-form').submit();
        });


        //Datatable column toggler
        $('span.col-toggle').on('click', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column($(this).attr('data-column'));

            // Toggle the visibility
            column.visible(!column.visible());
        });
    });

    $(".filter-field-location").each(function () {
        var name = $(this).attr('key');
        $(this).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '/get-filter-fields-location',
                dataType: "json",
                data: function (params) {
                    var query = {
                        search: params.term,
                        type: name
                    }

                    // Query parameters will be ?search=[term]&type=public
                    return query;
                },
                processResults: function (data) {
                    // Tranforms the top-level key of the response object from 'items' to 'results'
                    return {
                        results: data
                    };
                },

            }
        });

        $(document).on("click", ".asset-tracking-btn", function (e) {
            $('#asset-tracking-modal').modal('show');
            $('#asset-tracking-modal').find('select').next().addClass('chosen-with-drop').find('input').focus();
            var userId = $(this).attr('data-user');
            var trackingNumber = $(this).attr('data-tracking-number');
            $('#asset-tracking-modal').find('#user_id').val(userId);
            $('#asset-tracking-modal').find('#tracking_number').val(trackingNumber);
        });

        $("#tracking-number-submit").on('click', function () {
            formSubmit("#tracking-number-form");
        });
        function formSubmit(myForm) {
            $(myForm).submit();
        }
        $('#HardwareChoiceModal').on('show.bs.modal', function (e) {
            var data = $(e.relatedTarget).data('hardware-choices');
            var choices = "";

            $.each(data, function (i, item) {
                choices += '<li>' + item + '</li>'
            });

            $(this).find('#hardware-choices').html(choices);
        });

        $("#shipment-status-sync").click(function (e) {
            e.preventDefault();
            $('#shipment-status-sync').hide();
            $("#sync-success").html('Shipment status sync started. Please wait. It may take a while.').css('text-align', 'left').show();
            $.ajax({
                type: "post",
                url: "{{ route('shipment-status-sync') }}",
                success: function (data) {
                    if (data.status == 'success') {
                        $("#sync-success").html(data.message);
                    } else {
                        $("#sync-success").html('').hide();
                        $("#sync-error").html(data.message).show();
                    }

                    $('#shipment-status-sync').show();
                }
            });
        });
    });
</script>