<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>

<script>

    $(document).ready(function () {
        $('.chosen-select').chosen({ width: "100%" }).change(function () {
            $(this).closest('.form-group').next().find('input').focus();
        });

        $.fn.serializeObject = function () {
            var obj = {};

            $.each(this.serializeArray(), function (i, o) {
                var n = o.name, v = o.value;

                obj[n] = obj[n] === undefined ? v
                    : $.isArray(obj[n]) ? obj[n].concat(v)
                        : [obj[n], v];
            });

            return obj;
        };

        var table = $('.footable').DataTable({

            "processing": true,
            "serverSide": true,
            scrollCollapse: false,
            scrollX: false,
            scrollY: false,
            "ajax": {
                "url": "{{ route('new-hire-forecasting-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "hardware_standard" },
                { "data": "technical_spec" },
                { "data": "techspec_avg_value" },
                { "data": "quantity_needed" },
                { "data": "quantity_available" },
                { "data": "purchase_indicator" }
            ],
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: "_all" }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,

        });

        var delay = (function () {
            var timer = 0;
            return function (callback, ms) {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            };
        })();

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $(".chosen-select").on('change', function () {
            $('#search-form').submit();
        });

    });

</script>