<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.sum.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>

<script>
    if (document.getElementById("departmentSelected")) {
        let dept = document.getElementById("departmentSelected").value;
        var selectedDept = dept.split(',');
    }
    else {
        var selectedDept = [];
    }


    $(document).ready(function () {
        $('.chosen-select').chosen({
            width: "100%"
        }).change(function () {
            $(this).closest('.form-group').next().find('input').focus();
        });
        $('.footable').footable();
    });
    function countDept(dept) {
        const counts = {};
        selectedDept.forEach((dept) => {
            counts[dept] = (counts[dept] || 0) + 1;
        });
        return counts[dept];
    }
    function removeDept(depta) {
        selectedDept.forEach((X) => {
            let index = selectedDept.indexOf(depta);

            if (index > -1) { // only splice array when item is found
                selectedDept.splice(index, 1); // 2nd parameter means remove one item only
            }
        });

    }
    function addForecastingRow() {
        $('#forecasting-tool-ibox #error').html('').hide();
        var dept = $("#search-form .forecasting-row:last").find(".department-dropdown").val();
        if (countDept(dept) > 1) {
            $('#forecasting-tool-ibox #error').html('Selected department already in list. Please choose another one').show();
            return false;
        }
        if ($("#search-form .forecasting-row:last").find(".department-dropdown").val() != '' && $("#search-form .forecasting-row:last").find(
            ".newhire-count-field").val() != '') {
            selectedDept.push(dept);
            $("#search-form .forecasting-row:last").find(".add-btn").remove();
            var assetRow = $("#forcastingRow .forecasting-row").clone();
            assetRow.appendTo("#forecasting-container");
            $("#search-form .department-dropdown").chosen();
            $("#search-form .forecasting-row:last").find(".department-dropdown").trigger("chosen:updated");

        } else {
            $('#forecasting-tool-ibox #error').html('Please fill exisiting row').show();
        }

    }
    $(document).on('click', '#search-field-form-submit', function (e) {

        $('#forecasting-tool-ibox #error').html('').hide();
        var error = false;
        $('#search-form input:required').each(function () {
            if ($(this).val() === '')
                error = true;
        });
        $('#search-form select:required').each(function () {
            if ($(this).val() === '')
                error = true;
        });

        if (error) {
            $('#forecasting-tool-ibox #error').html('Please fill all fields').show();
        } else {
            var form = $('#search-form')[0];
            var data = new FormData(form);
            $('#search-form').submit();
        }

    });
    $(document).on('change', '.department-dropdown', function (e) {
        $('#forecasting-tool-ibox #error').html('').hide();
        if ($.inArray($(this).val(), selectedDept) > -1) {
            $('#forecasting-tool-ibox #error').html('Selected department already in list. Please choose another one').show();
            $(this).val('').trigger("chosen:updated");
        }

    });
    $(document).on('click', '.delete-row', function (e) {
        $('#forecasting-tool-ibox #error').html('').hide();
        let department = $(this).parents(".forecasting-row").find('.department-dropdown').val();
        removeDept(department);
        // alert(selectedDept.toString());
        $(this).parents(".forecasting-row").remove();
        $("#search-form .forecasting-row:last").find('#add-hardwarekit-row').remove();
        $("#search-form .forecasting-row:last").append(
            '<div class="col-md-2 buttons" id="add-hardwarekit-row"><a href="javascript:void(0)"  title="Add another row" class="btn btn-link add-btn" onclick="addForecastingRow()" ><i class="icon icon-e-add"></i></a> <a href="javascript:void(0)" class="btn btn-link delete-row" title="Remove" ><i class="icon icon-delete-forever text-danger"></i></a></div>'
        );
        $("#search-form .forecasting-row:first").find('.delete-row').remove();
        $("#search-form .forecasting-row:first #add-hardwarekit-row").css("top", "22px");
    });
    $(".month-year").datepicker({
        format: "M-yyyy",
        viewMode: "months",
        minViewMode: "months",
        clearBtn: true

    });
</script>

<script src="/js/jquery.table2excel.min.js"></script>
<script>

    function exportReportToExcel(idName) {

        var table = $('#' + idName);
        if (table && table.length) {

            $(table).table2excel({
                exclude: ".noExl",
                name: "Excel Document Name",
                filename: "Newhire-forecasting-report" + new Date().toISOString().replace(/[\-\:\.]/g, "") + ".xls",
                fileext: ".xls",
                exclude_img: true,
                exclude_links: true,
                exclude_inputs: true

            });
        }
    }

</script>
<script>
    $('.main-row').click(function () {
        $(this).find('i').toggleClass('fa-plus-circle fa-minus-circle');
    });
</script>