<script>
$(document).ready(function () {
    getWidgetData();

    $("#search-form").submit((e) => {
        getWidgetData();
    });

    function getWidgetData () {
        $.ajax({
            type: "POST",
            url: "{{ route('average-deployment-widget-data') }}",
            data: $("#search-form").serializeObject(),
            dataType: "json",
            success: function (result) {
                let assetsAssignedCount = result.assetsAssignedCount;
                let assetsAssignedAfterStartDateCount = result.assetsAssignedAfterStartDateCount;
                let assetsAssignedOnDate = result.assetsAssignedOnDate;
                let averageAssetsAssignedAfterStartDateCount = assetsAssignedOnDate / assetsAssignedCount
                $("#new_hires").html(result.newHiresCount);
                $("#assets_assigned").html(result.assetsAssignedCount);
                $("#assets_assigned_after_start_date").html(result.assetsAssignedAfterStartDateCount);
                $("#assets_assigned_on_time").html(!isNaN(averageAssetsAssignedAfterStartDateCount) ? averageAssetsAssignedAfterStartDateCount.toFixed(2) : 0);
            }
        })
    }

    $("#employee_name").on('keyup change', (e) => {
        $('#search-form').submit();
    });
});
</script>