@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'New Hires'])
<div class="wrapper-content">
    <div class="container-fluid">

        @include('partials.success')
		@include('partials.error-message')
		@include('settings.partials.success-message')
		@include('settings.partials.delete-message')

        @include('reports.partials.saved-searchs')
        @include('reports.new-hire.filters.new-hire-employees-filter')


        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    @include('partials.sync-messages')
                    <a class="btn btn-primary" id="jira-sync">Manual Sync</a>
                    <a class="btn btn-primary" id="shipment-status-sync">Shipment Status Sync</a>
                    <a href="#" id="export-user-csv" class="btn btn-primary">Export to CSV</a>
                </div>
            </div>
            <div class="ibox-content">

                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

                <div class="dt-coltoggler-wrapper">
                    <p>Click to toggle table columns: </p>
                    <span class="col-toggle" data-column="0">ID</span>
                    <span class="col-toggle" data-column="1">First Name</span>
                    <span class="col-toggle" data-column="2">Last Name</span>
                    <span class="col-toggle" data-column="3">Email</span>
                    <span class="col-toggle" data-column="4">Title</span>
                    <span class="col-toggle" data-column="5">User Type</span>
                    <span class="col-toggle" data-column="6">Start Date</span>
                    <span class="col-toggle" data-column="7">Department</span>
                    <span class="col-toggle" data-column="8">Work Location</span>
                    <span class="col-toggle" data-column="9">Modified Date</span>
                    <span class="col-toggle" data-column="10">Modified By</span>
                    <span class="col-toggle" data-column="11"># of Assets</span>
                    <span class="col-toggle" data-column="12">Ticket #</span>
                    <span class="col-toggle" data-column="13">Ticket Status</span>
                    <span class="col-toggle" data-column="14">Tracking #</span>
                    <span class="col-toggle" data-column="15">Shipment Status</span>
                </div>


                <table class="footable table table-stripped table-hover nowrap" data-page-size="50" data-filter=#filter>

                    <thead>

                        <tr>

                            <th>#</th>

                            <th>First Name</th>

                            <th>Last Name</th>

                            <th>Email</th>

                            <th>Title</th>

                            <th>User Type</th>

                            <th>Start Date</th>

                            <th>Department</th>

                            <th>Work Location</th>

                            <th>Modified Date</th>

                            <th>Modified By</th>

                            <th># of Assets</th>

                            <th>Ticket #</th>

                            <th>Ticket Status</th>

                            <th>Tracking #</th>

                            <th>Shipment Status</th>

                            <th>Actions</th>

                        </tr>

                    </thead>

                    <tbody>


                    </tbody>

                </table>


            </div>

        </div>
    </div>

</div>
@include('reports.new-hire.modals.asset-assign')
@include('reports.new-hire.modals.assigned-assets')
@include('reports.new-hire.modals.hardware-choices')
@include('reports.new-hire.modals.tracking-number')
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.new_hire'),'helpTitle'=>config('help-links.help_titles.new_hire')])
@endsection

@section('after_scripts')

@include('reports.new-hire.scripts.new-hire-employees')
@include('reports.new-hire.scripts.jira-sync')

@stop