@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Forecasting Tool'])
@include('reports.new-hire.partials.forecasting-submenu')

<div class="wrapper-content">
    <div class="container-fluid">
        @include('reports.new-hire.filters.forecasting-tool-filter')

        @if ($forecastingData)
        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <a href="#" onclick="exportReportToExcel('forecasting-table')"
                    class="btn btn-primary">Export to CSV</a>
                </div>
            </div>

            <div class="ibox-content">
                @include('partials.success')
                @if($startMonth!='' || $endMonth!='')
                <h2 class="text-center" style="padding:20px">New Hires Forecasting @if($startMonth!='') - {{
                    $startMonth }} @endif
                    @if($endMonth!='') - {{ $endMonth }} @endif</h2>
                    @endif
                    <div class="table-responsive">
                        <table id="forecasting-table" class="footable table table-stripped table-hover" data-page-size="50"
                        data-filter=#filter>

                        <thead>

                            <tr class="main-row">
                                <th class="noExl"></th>

                                <th>Department</th>

                                <th>Total Cost</th>

                                <th>New Hires</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($forecastingData as $department =>$forecastingDataRow)
                            @php

                            $total_cost = array_sum(array_column($forecastingDataRow,'cost_cal'));
                            @endphp
                            <tr data-toggle="collapse" data-target="#{{str_replace(' ','',$department)}}"
                            class="accordion-toggle main-row">
                            <td class="noExl"><button class="btn btn-primary btn-xs"><i
                                class="icon icon-e-add"></i></button></td>
                                <td>{{$department}}</td>

                                <td>${{$total_cost}}</td>
                                <td>{{ $forecastingDataRow[0]['quantity_needed'] }}</td>

                            </tr>

                            <tr class="main-row noExl">
                                <td colspan="12" class="hiddenRow">
                                    <div class="accordian-body collapse noExl"
                                    id="{{str_replace(' ','',$department)}}">
                                    <table class="footable table table-stripped table-hover noExl" data-page-size="50"
                                    data-filter=#filter>

                                    <thead class="noExl">

                                        <tr>



                                            <th>Hardware Standard</th>

                                            <th>Technical Specs</th>

                                            <th>Average Value</th>

                                            <th>Quantity Needed</th>

                                            <th>Total Cost</th>

                                            <th>Quantity Reserved for New Hires</th>

                                            <th>Quantity Available</th>

                                            <th>Purchase Indicator</th>

                                        </tr>

                                    </thead>

                                    <tbody class="noExl">
                                        @forelse ($forecastingDataRow as $forecastingEach)

                                        <tr>
                                            <td>{{ $forecastingEach['hardware_standard'] }}</td>

                                            <td>{{ $forecastingEach['tech_spec'] }}</td>

                                            <td>{{ $forecastingEach['avg_value'] }}</td>

                                            <td> {{ $forecastingEach['quantity_needed'] }} </td>

                                            <td> {{ $forecastingEach['cost'] }} </td>

                                            <td> {{ $forecastingEach['quantity_reserved'] }} </td>

                                            <td> {{ $forecastingEach['quantity_available'] }} </td>

                                            <td> {{ $forecastingEach['purchase_indicator'] }} </td>

                                        </tr>
                                        @empty
                                        <tr class="noExl">
                                            <td class="noExl" colspan="8">No details available in the
                                                system.</td>
                                            </tr>
                                            @endforelse
                                        </tbody>

                                    </table>
                                </div>
                            </td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>


            </div>

        </div>

    </div>
    @endif

</div>

</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.new_hire_forecasting'),'helpTitle'=>config('help-links.help_titles.new_hire_forecasting')])
@endsection

@section('after_scripts')

@include('reports.new-hire.scripts.forecasting-tool-script')

<style>
    .hiddenRow {
        padding: 0 !important;
    }

    .chosen-container {
        width: 100% !important;
    }

    .clear {
        display: revert;
    }
</style>
@stop