<div class="ibox">
	<div class="ibox-title">
		<div class="ibox-tools">
			<h5>Filters</h5>			
			<a data-toggle="collapse" href="#collapseFilter" class="collapse-link"
			aria-controls="collapseFilter"> <i class="icon icon-e-delete"></i></a>
		</div>
	</div>
	<div class="collapse in" id="collapseFilter">
		<div class="ibox-content">
			<form method="post" id="search-form" action="">
				{{ csrf_field() }}
				<div class="row">
					
					<div class="col-sm-3 divHeight">
						<div class="form-group">
							<label class="control-label">User Name / Email / Employee ID</label>
							<input type="text" class="form-control" name="employee_name" id="employee_name"
							placeholder="Search by Name/Email/Employee ID" autocomplete="off" value={{$search ?
								(isset($search['employee_name']) ? ($search['employee_name']) : "" ) : "" }}>
							</div>
						</div>
						
						<div class="col-sm-3  divHeight" id="countDiv">
							<div class="form-group">
								<label class="control-label"># of Assets</label>
								<input type="number" class="form-control" name="no_of_assets" id="no_of_assets"
								autocomplete="off" value={{$search ? (isset($search['no_of_assets']) ?
								($search['no_of_assets']) : "" ) : "" }}>
							</div>
						</div>
						
						<div class="col-sm-3  divHeight">
							<div class="form-group">
								<label class="control-label">User Type</label>
								<select class="chosen-select" id="employee_type" multiple name="employee_type"
								data-placeholder="Select">
								@foreach(\App\Models\EmployeeType::has('users')->orderBy('name')->where('slug','!=', 'full_time')->get() as $type)
								<option value="{{$type->id}}" {{$search ? (isset($search['employee_type']) ?
									(is_array($search['employee_type']) ? (in_array($type->id,
									$search['employee_type']) ? 'selected' : "")
									: (($type->id == $search['employee_type']) ? 'selected' : ""))
									: "")
									: ""
								}}
								
								>{{$type->name}}</option>
								@endforeach
							</select>
						</div>
					</div>
					
					<div class="col-sm-3  divHeight">
						<div class="form-group">
							<label class="control-label">Full Time / Ext</label>
							<select class="chosen-select" id="fte" multiple name="fte"
							data-placeholder="Select">
							<option value="full_time" {{$search ? (isset($search['fte']) ?
							(is_array($search['fte']) ? (in_array('full_time',
							$search['fte']) ? 'selected' : "")
							: (('full_time' == $search['fte']) ? 'selected' : ""))
							: "")
							: ""
						}}>Full Time</option>
						<option value="ext" {{$search ? (isset($search['fte']) ?
						(is_array($search['fte']) ? (in_array('ext',
						$search['fte']) ? 'selected' : "")
						: (('ext' == $search['fte']) ? 'selected' : ""))
						: "")
						: ""
					}}>Ext</option>
				</select>
			</div>
		</div>
		
	</div>
	
	<div class="row">
		<div class="col-sm-3  divHeight">
			<div class="form-group">
				<label class="control-label">Department</label>
				<select class="chosen-select" multiple name="department" id="department"
				data-placeholder="Select">
				@foreach(\App\Models\Department::orderBy('name')->get() as $department)
				<option value="{{$department->id}}" {{$search ? (isset($search['department']) ?
					(is_array($search['department']) ? (in_array($department->id,
					$search['department']) ? 'selected' : "")
					: (($department->id == $search['department']) ? 'selected' : ""))
					: "")
					: ""
				}}
				
				>{{$department->name}}</option>
				@endforeach
			</select>
		</div>
	</div>
	<div class="col-sm-6">
		<div class="row">
			<div class="col-sm-6 divHeight">
				<div class="form-group">
					<label class="control-label">Start Date Range</label>
					<div class="form-group" id="data_1">
						<div class="input-group date">
							<span class="input-group-addon"><i
								class="icon icon-calendar-2"></i></span><input type="text"
								name="date_from" class="form-control" readonly
								data-mask="99/99/9999" id="date_from" placeholder="From"
								autocomplete="off" value={{$search ? (isset($search['date_from']) ?
								($search['date_from']) : "" ) : "" }}>
							</div>
						</div>
					</div>
				</div>
				
				<div class="col-sm-6 divHeight">
					<div class="form-group">
						<label class="control-label">&nbsp;</label>
						<div class="form-group" id="data_1">
							<div class="input-group date">
								<span class="input-group-addon"><i
									class="icon icon-calendar-2"></i></span><input type="text"
									class="form-control" data-mask="99/99/9999" readonly
									placeholder="To" name="date_to" id="date_to" autocomplete="off"
									value={{$search ? (isset($search['date_to']) ? ($search['date_to'])
									: "" ) : "" }}>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-12">
						<p><small><em>Start Date Range (Best results are when from = MONDAY and to =
							SUNDAY)</em></small></p>
						</div>
					</div>
				</div>
				<div class="col-sm-3  divHeight">
					<div class="form-group">
						<label class="control-label">Work Location</label>
						<select class="filter-field-location form-control" multiple name="work_location"
						id="work_location" key="city" data-placeholder="Select">
						@if($search)
						@if(isset($search['work_location']))
						@if(is_array($search['work_location']))
						@foreach($search['work_location'] as $value)
						<option value="{{$value}}" selected="selected">{{$value}}</option>
						@endforeach
						@else
						<option value="{{$search['work_location']}}" selected="selected">
							{{$search['work_location']}}</option>
							@endif
							@endif
							@endif
						</select>
					</div>
				</div>
			</div>
			
			
		</form>
	</div>
</div>
</div>
