@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Average Deployment Time', 'parentUrl' => '/new-hire', 'parentTitle' => 'New Hires'])
<div class="wrapper-content">
    <div class="container-fluid">

        @include('partials.success')
		@include('partials.error-message')
		@include('settings.partials.success-message')
		@include('settings.partials.delete-message')

        @include('reports.new-hire.filters.average-deployment-time-filter')
        @include('reports.new-hire.widgets.average-deployment-time-widgets')

        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <a href="#" id="export-csv" class="btn btn-primary" data-url="{{ route('average-deployment-time-export') }}" data-file-name="average-deployment-time">Export to CSV</a>
                </div>
            </div>
            <div class="ibox-content">
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
                </div>
                <table class="footable table table-stripped table-hover nowrap three-col-fixed has-column-toggler" data-page-size="50" data-role="ui-data-table" data-url="{{ route('average-deployment-time-data') }}" data-searching="false" data-ordering="false" data-fixed-header-columns-left="3">
                    <thead>
                        <tr>
                            <th data-col-name="id">#</th>
                            <th data-col-name="asset_tag">Asset Tag #</th>
                            <th data-col-name="serial_no">Serial #</th>
                            <th data-col-name="user_name">User Name</th>
                            <th data-col-name="hire_date">Hire Date</th>
                            <th data-col-name="assigned_date">Date Assigned</th>
                            <th data-col-name="no_of_days"># of Days</th>
                            <th data-col-name="title">Title</th>
                            <th data-col-name="department">Department</th>
                            <th data-col-name="work_location">Work Location</th>
                            <th data-col-name="storage_room">Storage Room</th>
                            <th data-col-name="ticket_no">Ticket #</th>
                            <th data-col-name="modified_date">Modified Date</th>
                            <th data-col-name="modified_by">Modified By</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.new_hire'),'helpTitle'=>config('help-links.help_titles.new_hire')])
@endsection

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('reports.scripts.datatable-column-toggle-script')
@include('reports.new-hire.scripts.average-deployment-time-scripts')
@stop