
<div class="ibox">
    <div class="ibox-title">
        <div class="ibox-tools">
            <h5>Filters</h5>
            <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"
           ><i class="icon icon-e-delete"></i></a>
        </div>
    </div>
    <div class="collapse in" id="collapseFilter">
        <div class="ibox-content">
            <form method="post" id="search-form" action="">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Type</label>
                            <select class="form-control select2 filter" multiple name="asset_type" id="asset_type"
                            data-placeholder="Select">
                                @foreach(\App\Models\AssetType::valid()->orderBy('name', 'ASC')->get() as $assetType)
                                <option value="{{$assetType->id}}">{{$assetType->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Manufacturer</label>
                            <select class="form-control select2 filter" multiple name="manufacturer"
                            id="manufacturer" data-placeholder="Select">
                                @foreach(\App\Models\Manufacturer::orderBy('name')->get() as $manufacturer)
                                <option value="{{$manufacturer->id}}">{{$manufacturer->name}}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Hardware Standard</label>
                            <select class="form-control select2 filter" multiple name="make_and_model"
                            id="make_and_model" data-placeholder="Select">
                            @foreach(\App\Models\MakeAndModel::valid()->orderBy('name', 'ASC')->get() as $hardware)
                                <option value="{{$hardware->id}}">{{ $hardware->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Location</label>
                            <select class="filter-field-storage-location form-control filter" multiple name="location" id="location" key="room_name" data-placeholder="Select">
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">User</label>
                            <select class="filter-field-user form-control" multiple name="user" data-placeholder="Select">
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Stolen/Lost Date Range</label>
                            <div class="form-group">
                                <div class="input-group date">
                                    <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                    <input class="input-sm form-control filter readonly-white" name="date_from" value="{{ $dateFrom }}" type="text" readonly>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="input-group date">
                                    <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                    <input class="input-sm form-control filter readonly-white" name="date_to" value="{{ $dateTo }}" type="text" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
