@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Lost/Stolen Value','parentUrl' => '/report', 'parentTitle' =>
'Reports'])
<div class="wrapper-content">
    <div class="container-fluid">

        @include('reports.lost-or-stolen-value.partials.filter')
        @include('reports.lost-or-stolen-value.partials.widgets')

        <div class="ibox">

            <div class="ibox-title">
                <div class="ibox-tools">
                    <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                </div>
            </div>

            <div class="ibox-content">
                @include('partials.success')
                @include('partials.error-message')
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

                <div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
				</div>

                <table class="footable table table-stripped table-hover nowrap three-col-fixed has-column-toggler" data-page-size="50" data-filter=#filter>

                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Asset Tag #</th>
                            <th>Serial #</th>
                            <th class="sort-alpha">Asset Type</th>
                            <th>Hardware Standard </th>
                            <th>Asset Status </th>
                            <th>User/Location</th>
                            <th>Stolen/Lost Date</th>
                            <th>Age When Lost/Stolen</th>
                            <th>Original Value</th>
                            <th>Depreciated Value</th>
                            <th>Last Modified Date</th>
                            <th>Last Modified By</th>

                        </tr>

                    </thead>

                </table>

            </div>

        </div>



    </div>

</div>
@stop

@section('after_scripts')

@include('reports.scripts.common')
@include('reports.scripts.filter-options-with-ajax')
@include('reports.scripts.datatable-column-toggle-script')
@include('reports.lost-or-stolen-value.scripts.script')
@include('assets.partials.scripts.dropdown-script')


@stop

@section('help')
@include('help.users')
@endsection