@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Linked Devices Report', 'parentUrl' => '/report', 'parentTitle'
=> 'Reports'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox">
            <div class="ibox-content">
                <div class="form-group">
                    <input type="text" class="form-control input-sm m-b-xs" id="filter"
                    placeholder="Find a linked device">
                    
                </div>
                
                <table class="footable table table-stripped table-hover" data-page-size="10" data-filter=#filter id="linkedDevicesTable">
                    
                    <thead>
                        
                        <tr>
                            
                            <th>Parent Serial #</th>
                            
                            <th>Hardware Standard</th>
                            
                            <th>Technical Specs</th>
                            
                            <th>Child Serial #</th>
                            
                            <th>Hardware Standard</th>
                            
                            <th>Technical Specs</th>
                            
                        </tr>
                        
                    </thead>
                    
                    <tbody>
                        
                        @foreach($childAssets as $childAsset)
                        
                        <tr>
                            
                            <td><a href="{{route('assets.show', ['asset' => $childAsset->parentAsset->id])}}">{{$childAsset->parentAsset->serial_no
                                ?? ''}}</a></td>
                                
                                <td>{{$childAsset->parentAsset->makeAndModel->makeModelName ?? ''}}</td>
                                
                                <td>{{$childAsset->parentAsset->technicalSpec->details ?? ''}}</td>
                                
                                <td><a
                                    href="{{route('assets.show', ['asset' => $childAsset->id])}}">{{$childAsset->serial_no}}</a>
                                </td>
                                
                                <td>{{$childAsset->makeAndModel->makeModelName ?? ''}}</td>
                                
                                <td>{{$childAsset->technicalSpec->details ?? ''}}</td>
                                
                            </tr>
                            
                            @endforeach
                            
                        </tbody>
                        
                    </table>
                    
                </div>
                
            </div>
            
        </div>
        @stop
        
        @section('help-links')
        @include('help.help-links',['helpLink'=>config('help-links.help_links.asset_reports'),'helpTitle'=>config('help-links.help_titles.asset_reports')])
        @endsection
        
        @section('after_scripts')
        @include('settings.partials.responsive-fixedheader')
        <script>
            $('#filter').keyup(function(){
                responsiveTable.search($(this).val()).draw() ;
            });
        </script>
        @stop