<script>
    $(document).ready(function() {

        // Initialize the DataTable for the report data
        var table = $('.footable').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('consumption-report.data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function(result) {
                    result.form = $('#search-form').serializeObject();
                },
            },
            "columns": [
            { "data": "id" },
            { "data": "asset_tag" },
            { "data": "serial" },
            { "data": "asset_type" },
            { "data": "manufacturer" },
            { "data": "hardware_standard" },
            { "data": "tech_specs" },
            { "data": "asset_status" },
            { "data": "prev_asset_status" },
            { "data": "userlocation" },
            { "data": "user_type" },
            { "data": "storage_location" },
            { "data": "storage_country" },
            { "data": "storage_region" },
            { "data": "user_department" },
            { "data": "user_work_location" },
            { "data": "date_assigned" },
            { "data": "created_date" },
            { "data": "last_modified_by" },
            ],
            "lengthMenu": [[20, 50, 100, 200], [20, 50, 100, 200]],
            "columnDefs": [{ "orderable": false, "targets": "_all" }],
            "aaSorting": [],
            "bAutoWidth": false,
            "bFilter": true,
            "searching": false,
            "responsive": false,
            "scrollCollapse": false,
            "scrollX": true,
            "scrollY": false,
            fixedHeader: true,
            fixedColumns: {
                left: 3
            },
            "fnDrawCallback": function( oSettings ){
                if ( table.page.info().recordsTotal == 0 ) {
                    $("#export-csv").hide();
                } else {
                    $("#export-csv").show();
                }
            },
        });

        // Handle form submission to trigger data reload
        $('#search-form').submit(function(e) {
            e.preventDefault();
            table.draw();
        });

        // Handle export button click to export data
        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "{{route('consumption-report.export')}}",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)
                        window.navigator.msSaveBlob(blob, "consumption-report.csv");
                    else
                    {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = "consumption-report.csv";
                        document.body.appendChild(a);
                        a.click();
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });

        // Data table column toggle
        $('span.col-toggle').on('click', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column($(this).attr('data-column'));

            // Toggle the visibility
            column.visible(!column.visible());
        });

    });
</script>
