<div class="col-lg-12">
    <div class="ibox">
        <div class="ibox-title">
            <div class="ibox-tools">
                <h5>Filters</h5>
                <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"
            ><i class="icon icon-e-delete"></i></a>
           </div>
        </div>
        <div class="collapse  in" id="collapseFilter" aria-expanded="true">
            <div class="ibox-content">
                <form method="post" id="search-form" action="">
                    {{ csrf_field() }}
                    <div class="row">
                        <!-- Serial Number Filter -->
                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Serial #</label>
                                <select class="report-filters filter-field form-control" multiple name="serial_no" key="serial_no" id='serial_no' data-placeholder="Select">
                                    <!-- Options for Serial Number -->
                                </select>
                            </div>
                        </div>

                        <!-- Asset Tag # Filter -->
                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Asset Tag #</label>
                                <select class="report-filters filter-field form-control" multiple name="asset_tag" key="asset_tag" id='asset_tag' data-placeholder="Select">
                                    <!-- Options for Asset Tag # -->
                                </select>
                            </div>
                        </div>

                        <!-- Asset Type -->
                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Asset Type </label>
                                <select class="report-filters chosen-select" id="asset_type" multiple name="asset_type" data-placeholder="Select">
                                    @foreach($filterDataOptions['assetTypes'] as $assetType)
                                    <option value="{{$assetType->id}}" >{{$assetType->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Manufacturer Filter -->
                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Manufacturer </label>
                                <select class="report-filters chosen-select" id="manufacturer" multiple name="manufacturer" data-placeholder="Select">
                                    @foreach($filterDataOptions['manufacturers'] as $manufacturer)
                                    <option value="{{$manufacturer->id}}" >{{$manufacturer->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Hardware Standard Filter -->
                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Hardware Standard</label>
                                <select class="report-filters form-control select2" multiple name="make_and_model" id="make_and_model" data-placeholder="Select">
                                    @foreach($filterDataOptions['makeandmodel'] as $hardware)
                                    <option value="{{ $hardware->id }}">{{ $hardware->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Tech Specs Filter -->
                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Technical Specs</label>
                                <select class="report-filters form-control select2" multiple name="technical_spec" id="technical_spec" data-placeholder="Select">
                                    @foreach($filterDataOptions['techSpecs'] as $technicalSpec)
                                    <option value="{{ $technicalSpec->id }}">{{ $technicalSpec->details }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                         <!-- Asset Status Filter -->
                         <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Asset Status</label>
                                <select class="report-filters form-control select2" multiple name="asset_status" id="asset_status" data-placeholder="Select">
                                    @foreach(\App\Models\AssetStatus::getWithAssetStatus(config('reports.consumption_report.include_statuses'))->orderBy('name', 'ASC')->get() as $status)
                                    <option value="{{ $status->id }}">{{ $status->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                         <!-- Asset Previous Status Filter -->
                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Previous Asset Status</label>
                                <select class="chosen-select report-filters" multiple name="previous_status" id="previous_status" data-placeholder="Select">
                                    @foreach(\App\Models\AssetStatus::getWithoutAssetStatus(config('reports.consumption_report.exclude_prev_statuses'))->reportStatus()->orderBy('name')->get() as $status)
                                    <option value="{{$status->id}}">{{$status->name}}</option>
                                    @endforeach
                                </select>
                            </div>
					    </div>

                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Location</label>
                                <select class="report-filters filter-field-location form-control" multiple name="new_location" id="new_location" key="room_name" data-placeholder="Select">
                                </select>
                            </div>
                        </div>

                        <!-- User Filter -->
                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">User</label>
                                <select class="report-filters filter-field-user form-control" multiple name="user" id="user" key="userName" data-placeholder="Select">
                                    <!-- Options for User -->
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">User Type</label>
                                <select class="form-control select2 report-filters" id="employee_type" multiple name="employee_type" data-placeholder="Select">
                                    @foreach(\App\Models\EmployeeType::has('users')->orderBy('name')->where('slug', '!=', 'full_time')->get() as $type)
                                    <option value="{{$type->id}}">{{$type->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Work Location Filter -->
                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">User Work Location</label>
                                <select class="report-filters filter-field-location form-control" multiple name="work_location" id="work_location" key="city" data-placeholder="Select">
                                    <!-- Options for Work Location -->
                                </select>
                            </div>
                        </div>

                        <!-- Department Filter -->
                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">User Department</label>
                                <select class="report-filters form-control select2" multiple name="department" id="department" data-placeholder="Select">
                                    @foreach(\App\Models\Department::orderBy('name')->get() as $department)
                                    <option value="{{ $department->id }}">{{ $department->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Last Modified By</label>
                                <select class="report-filters filter-field-user form-control" multiple name="modified_by" id="modified_by" key="userName" data-placeholder="Select">
                                    <!-- Options for User -->
                                </select>
                            </div>
                        </div>
                        <!-- Location Filter -->
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Storage Location</label>
                                <select class="report-filters form-control select2" multiple name="location" id="location" data-placeholder="Select">
                                    @foreach(\App\Models\Location::Warehouses()->orderBy('room_name')->get() as $location)
                                    <option value="{{ $location->id }}">{{ $location->room_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Country Filter -->
                        <div class="col-sm-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Storage Country</label>
                                <select class="report-filters chosen-select" id="country" multiple name="country" data-placeholder="Select">
                                    @foreach(\App\Models\Country::orderBy('name')->get() as $country)
                                    <option value="{{ $country->id }}">{{ $country->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Region Filter -->
                        <div class="col-sm-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Storage Region</label>
                                <select class="report-filters chosen-select" id="region" multiple name="region" data-placeholder="Select">
                                    @foreach(\App\Models\Region::orderBy('name')->get() as $region)
                                    <option value="{{ $region->id }}">{{ $region->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
							<div class="form-group">
								<label>Assigned Date Range</label>
								<div class="form-group">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                        <input type="text" name="assigned_date_from" class="form-control readonly-white" data-mask="99/99/9999" id="assigned_date_from" placeholder="From" autocomplete="off" readonly="readonly" value="{{Carbon\Carbon::now()->subMonths(3)->format('m/d/Y')}}">
									</div>
								</div>

								<div class="form-group">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                        <input type="text" class="form-control readonly-white" data-mask="99/99/9999" placeholder="To" name="assigned_date_to" id="assigned_date_to" autocomplete="off"  readonly="readonly" value="{{Carbon\Carbon::now()->format('m/d/Y')}}">
									</div>
								</div>
							</div>
						</div>

                        <div class="col-md-3">
							<div class="form-group">
								<label>Created Date Range</label>
								<div class="form-group">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                        <input type="text" name="created_date_from" class="form-control readonly-white" data-mask="99/99/9999" id="created_date_from" placeholder="From" autocomplete="off" value="" readonly="readonly">
									</div>
								</div>

								<div class="form-group">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                        <input type="text" class="form-control readonly-white" data-mask="99/99/9999" placeholder="To" name="created_date_to" id="created_date_to" autocomplete="off" value="" readonly="readonly">
									</div>
								</div>
							</div>
						</div>

                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
