@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Consumption Report', 'parentUrl' => '#', 'parentTitle' => 'Inventory Control'])
@include('reports.inventory-consumption.partials.submenu')

<div class="wrapper-content">
    <div class="container-fluid">

        <div class="row">
            @include('reports.inventory-consumption.partials.consumption-report-filter')
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                        </div>
                    </div>
                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <div class="dt-coltoggler-wrapper">
                            <p>Click to toggle table columns: </p>
                        </div>
                        <div class="table-responsive">
                            <table class="footable table nowrap table-stripped table-hover three-col-fixed has-column-toggler" data-page-size="50" data-filter=#filter>
                                <thead>
                                    <tr>
                                        <tr>
                                            <th>#</th>
                                            <th>Asset Tag #</th>
                                            <th>Serial #</th>
                                            <th>Asset Type</th>
                                            <th>Manufacturer</th>
                                            <th>Hardware Standard</th>
                                            <th>Technical Specs</th>
                                            <th>Asset Status</th>
                                            <th>Previous Asset Status</th>
                                            <th>User/Location</th>
                                            <th>User Type</th>
                                            <th>Storage Location</th>
                                            <th>Storage Country</th>
                                            <th>Storage Region</th>
                                            <th>User Department</th>
                                            <th>User Work Location</th>
                                            <th>Date Assigned</th>
                                            <th>Created Date</th>
                                            <th>Last Modified By</th>
                                        </tr>
                                    </thead>

                                    <tbody>

                                    </tbody>

                                </table>
                            </div>

                        </div>

                    </div>

                </div>

            </div>
        </div>

    </div>
    @stop

    @section('after_scripts')
    @include('reports.scripts.common')
    @include('reports.scripts.filter-options-with-ajax')
    @include('reports.scripts.datatable-column-toggle-script');
    @include('reports.inventory-consumption.scripts.consumption-report')
    @stop

