
<div class="ibox">
    <div class="ibox-title">
        <div class="ibox-tools">
            <h5>Filters</h5>
            <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"
           ><i class="icon icon-e-delete"></i></a>
        </div>
    </div>
    <div class="collapse in" id="collapseFilter">
        <div class="ibox-content">
            <form method="post" id="search-form" action="">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Type</label>
                            <select class="form-control select2 filter" multiple name="asset_type" id="asset_type" data-placeholder="Select">
                            @foreach(\App\Models\AssetType::getBySlugList(config('reports.in-stock-computers.include_asset_types'))->valid()->orderBy('name', 'ASC')->get() as $assetType)
                                <option value="{{$assetType->id}}" {{ isset($search['asset_type'])
                                    ? in_array($assetType->id, $search['asset_type']) ? "selected"
                                    : "" : "" }}>{{$assetType->name}}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Manufacturer</label>
                            <select class="form-control select2 filter" multiple name="manufacturer" id="manufacturer" data-placeholder="Select">
                            @foreach(\App\Models\Manufacturer::orderBy('name')->get() as $manufacturer)
                                <option value="{{$manufacturer->id}}" {{$search ?
                                    (isset($search['manufacturer']) ?
                                    (is_array($search['manufacturer']) ?
                                    (in_array($manufacturer->id, $search['manufacturer']) ?
                                    'selected' : "")
                                    : (($manufacturer->id == $search['manufacturer']) ?
                                    'selected' : ""))
                                    : "")
                                    : ""
                                }}>{{$manufacturer->name}}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label class="control-label">Hardware Standard</label>
                        <select class="form-control select2 filter" multiple name="make_and_model"
                        id="make_and_model" data-placeholder="Select">
                        @foreach(App\Models\MakeAndModel::with('manufacturer')->valid()->orderBy('name', 'ASC')->get() as $hardware)
                            <option value="{{$hardware->id}}">{{$hardware->MakeModelName}}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Technical Specs</label>
                    <select class="form-control select2 filter" multiple name="tech_spec" id="technical_spec" data-placeholder="Select">
                        @foreach(\App\Models\TechnicalSpecs::valid()->orderBy('details', 'ASC')->get() as $tech_spec)
                        <option value="{{$tech_spec->id}}">{{$tech_spec->details}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            
            </div>
            <div class="row">


            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label">Asset Status</label>
                    <select class="form-control select2 filter" multiple name="status" id="status" data-placeholder="Select">
                    @foreach(\App\Models\AssetStatus::getWithAssetStatus(config('reports.in-stock-computers.include_statuses'))->orderBy('name')->get() as $status)
                        <option value="{{$status->id}}" {{
                            isset($search['asset_status']) ? in_array($status->id,
                            $search['asset_status']) ? "selected" : "" : ""
                        }}>{{$status->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="col-md-3">
            <div class="form-group">
                <label class="control-label">Location</label>
                <select class="filter-field-storage-location form-control filter" multiple name="location" id="location" key="room_name" data-placeholder="Select">
                </select>
            </div>
        </div>

    </div>
</form>
</div>
</div>
</div>
