@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Reports'])

<div class="wrapper-content">
  
  <div class="container-fluid">
    
    @include('partials.error-message')
    @include('partials.success')
    
    @if(count($favourites))
    <div class="ibox">
      <div class="ibox-title">
        <div class="ibox-tools">
          <h5>Favorites</h5>
          <a data-toggle="collapse" class="collapse-link" href="#favorites"><i class="icon icon-e-add"></i></a>
        </div>
      </div>
      
      <div class="collapse" id="favorites">
        <div class="ibox-content">
          <div class="row">
            @forelse ($favourites as $report)
            @if(isset(config('reports')[$report]))
            <div class="col-md-4">
              <ul class="list-group mb-0">
                <li class="list-group-item">
                  <a href="{{ config('reports')[$report]['link'] }}">{{ config('reports')[$report]['label'] }}</a>
                  <a class="add-favourite" data-report="{{ $report }}"><i class="icon icon-shape-star pull-right fav-icon"></i></a>
                </li>
              </ul>
            </div>
            @endif
            @empty
            @endforelse
            
          </div>
        </div>
      </div>
    </div>
    @endif
    
    <div class="ibox">
      <div class="ibox-title">
        <div class="ibox-tools">
          <h5>Asset Reports</h5>
          <a data-toggle="collapse" class="collapse-link" href="#asset-reports"><i class="icon icon-e-delete"></i></a>
        </div>
      </div>
      <div class="collapse in" id="asset-reports">
        <div class="ibox-content">
          <div class="row">
            <div class="col-md-4">
              <ul class="list-group">
                <li class="list-group-item">
                  <a href="/report/assets-created">Assets Created</a>
                  <a class="add-favourite" data-report="assets_created"><i class="icon icon-shape-star pull-right @if (in_array('assets_created', $favourites))fav-icon @endif"></i></a>
                </li>
                {{-- <li class="list-group-item">
                  <a href="/inventory-control/cycle-count">Cycle Count</a>
                  <a class="add-favourite" data-report="cycle_count"><i class="icon icon-shape-star pull-right @if (in_array('cycle_count', $favourites))
                    fav-icon
                    @endif"></i></a>
                  </li> --}}
                  <li class="list-group-item">
                    <a href="/report/brandnew-assigned-to-contractor">Brand New, Assigned to Contractors</a>
                    <a class="add-favourite" data-report="brand_new_assigned_to_contractor"><i class="icon icon-shape-star pull-right @if (in_array('brand_new_assigned_to_contractor', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  <li class="list-group-item">
                    <a href="/report/brandnew-to-assigned">Brand New to Assigned</a>
                    <a class="add-favourite" data-report="brand_new_to_assigned"><i class="icon icon-shape-star pull-right @if (in_array('brand_new_to_assigned', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  <li class="list-group-item">
                    <a href="/report/damaged-trends">Damaged Trends</a>
                    <a class="add-favourite" data-report="damaged_trends"><i class="icon icon-shape-star pull-right @if (in_array('damaged_trends', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  
                  <li class="list-group-item">
                    <a href="/report/duplicate-assets">Duplicate Assets</a>
                    <a class="add-favourite" data-report="duplicate_assets"><i class="icon icon-shape-star pull-right @if (in_array('duplicate_assets', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  <li class="list-group-item">
                    <a href="{{ route('assigned-devices') }}">Assigned Devices</a>
                    <a class="add-favourite" data-report="assigned_devices"><i class="icon icon-shape-star pull-right @if (in_array('assigned_devices', $favourites)) fav-icon @endif"></i></a>
                  </li>
                </ul>
              </div>
              <div class="col-md-4">
                <ul class="list-group">
                  <li class="list-group-item">
                    <a href="{{ route('reused-devices') }}">Reused Devices</a>
                    <a class="add-favourite" data-report="reused_devices"><i class="icon icon-shape-star pull-right @if (in_array('reused_devices', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  
                  <li class="list-group-item">
                    <a href="{{ route('deployment') }}">Computers Deployed</a>
                    <a class="add-favourite" data-report="deployment_report"><i class="icon icon-shape-star pull-right @if (in_array('deployment_report', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  <li class="list-group-item">
                    <a href="{{ route('unrepairable') }}">Unrepairable</a>
                    <a class="add-favourite" data-report="unrepairable"><i class="icon icon-shape-star pull-right @if (in_array('unrepairable', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  <li class="list-group-item">
                    <a href="/report/repair-and-recovery">Repair And Recovery</a>
                    <a class="add-favourite" data-report="repair_and_recovery"><i class="icon icon-shape-star pull-right @if (in_array('repair_and_recovery', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  <li class="list-group-item">
                    <a href="/report/linked-devices">Linked Devices</a>
                    <a class="add-favourite" data-report="linked_devices"><i class="icon icon-shape-star pull-right @if (in_array('linked_devices', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  
                  <li class="list-group-item">
                    <a href="/report/asset-recovery">Asset Recovery</a>
                    <a class="add-favourite" data-report="asset_recovery"><i class="icon icon-shape-star pull-right @if (in_array('asset_recovery', $favourites)) fav-icon @endif"></i></a>
                  </li>
                </ul>
              </div>
              <div class="col-md-4">
                <ul class="list-group">
                  <li class="list-group-item">
                    <a href="/report/warranty-expiration-date">Warranty Expiration Date</a>
                    <a class="add-favourite" data-report="warranty_expiration_date"><i class="icon icon-shape-star pull-right @if (in_array('warranty_expiration_date', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  
                  <li class="list-group-item">
                    <a href="{{ route('average-time-in-brand-new') }}">Average Time Brand New</a>
                    <a class="add-favourite" data-report="average_time_brand_new_report"><i class="icon icon-shape-star pull-right @if (in_array('average_time_brand_new_report', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  
                  <li class="list-group-item">
                    <a href="{{ route('assets-assigned-by-month') }}">Assets Assigned By Month</a>
                    <a class="add-favourite" data-report="assets_assigned_by_month_report"><i class="icon icon-shape-star pull-right @if (in_array('assets_assigned_by_month_report', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  
                  <li class="list-group-item">
                    <a href="/report/os-compliance-report/apple">Operating System Compliance</a>
                    <a class="add-favourite" data-report="os_compliance"><i class="icon icon-shape-star pull-right @if (in_array('os_compliance', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  
                  <li class="list-group-item">
                    <a href="{{ route('computer-by-age') }}">Computers By Age</a>
                    <a class="add-favourite" data-report="computers_by_age"><i class="icon icon-shape-star pull-right @if (in_array('computers_by_age', $favourites)) fav-icon @endif"></i></a>
                  </li>
                  {{-- <li class="list-group-item">
                    <a href="{{ route('computers-report') }}">Computers</a>
                    <a class="add-favourite" data-report="computers"><i class="icon icon-shape-star pull-right @if (in_array('computers', $favourites))
                      fav-icon @endif"></i></a>
                    </li> --}}
                    <li class="list-group-item">
                      <a href="{{ route('lost-or-stolen-value-report') }}">Lost / Stolen Value</a>
                      <a class="add-favourite" data-report="lost_or_stolen_value"><i class="icon icon-shape-star pull-right @if (in_array('lost_or_stolen_value', $favourites)) fav-icon @endif"></i></a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
        
        <div class="ibox">
          <div class="ibox-title">
            <div class="ibox-tools">
              <h5>User Reports</h5>
              <a data-toggle="collapse" class="collapse-link" href="#user-reports"><i class="icon icon-e-delete"></i></a>
            </div>
          </div>
          <div class="collapse in" id="user-reports">
            <div class="ibox-content">
              <div class="row">
                <div class="col-md-4">
                  <ul class="list-group">
                    <li class="list-group-item">
                      <a href="/report/assets-by-department">Assets By Department</a>
                      <a class="add-favourite" data-report="assets_by_department"><i class="icon icon-shape-star pull-right @if (in_array('assets_by_department', $favourites)) fav-icon @endif"></i></a>
                    </li>
                    {{-- <li class="list-group-item">
                      <a href="/inventory-control/asset-type-to-user">Users to Asset Ratio</a>
                      <a class="add-favourite" data-report="asset_type_to_user"><i class="icon icon-shape-star pull-right @if (in_array('asset_type_to_user', $favourites))
                        fav-icon
                        @endif"></i></a>
                      </li> --}}
                      
                    </ul>
                  </div>
                  <div class="col-md-4">
                    <ul class="list-group">
                      <li class="list-group-item">
                        <a href="/report/upcoming-refresh">Upcoming Refresh</a>
                        <a class="add-favourite" data-report="upcoming_refresh"><i class="icon icon-shape-star pull-right @if (in_array('upcoming_refresh', $favourites)) fav-icon @endif"></i></a>
                      </li>
                      
                    </ul>
                  </div>
                  <div class="col-md-4">
                    <ul class="list-group">
                      <li class="list-group-item">
                        <a href="/report/active-users-with-no-asset">Active Users with No Assets Assigned</a>
                        <a class="add-favourite" data-report="active_users_with_no_asset"><i class="icon icon-shape-star pull-right @if (in_array('active_users_with_no_asset', $favourites)) fav-icon @endif"></i></a></li>
                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="ibox">
              <div class="ibox-title">
                <div class="ibox-tools">
                  <h5>Finance Reports</h5>
                  <a data-toggle="collapse" class="collapse-link" href="#finance-reports"><i class="icon icon-e-delete"></i></a>
                </div>
              </div>
              <div class="collapse in" id="finance-reports">
                <div class="ibox-content">
                  <div class="row">
                    <div class="col-md-4">
                      <ul class="list-group">
                        <li class="list-group-item">
                          <a href="/report/depreciation-value">Depreciation Value</a>
                          <a class="add-favourite" data-report="depreciation_value"><i class="icon icon-shape-star pull-right @if (in_array('depreciation_value', $favourites)) fav-icon @endif"></i></a>
                        </li>
                      </ul>
                    </div>
                    <div class="col-md-4">
                      <ul class="list-group">
                        <li class="list-group-item">
                          <a href="{{ route('use-tax-report') }}">Use Tax</a>
                          <a class="add-favourite" data-report="use_tax"><i class="icon icon-shape-star pull-right @if (in_array('use_tax', $favourites)) fav-icon @endif"></i></a>
                        </li>
                      </ul>
                    </div>
                    <div class="col-md-4">
                      <ul class="list-group">
                        <li class="list-group-item">
                          <a href="/report/asset-recovery-value">Asset Recovery Value</a>
                          <a class="add-favourite" data-report="asset_recovery_value"><i class="icon icon-shape-star pull-right @if (in_array('asset_recovery_value', $favourites)) fav-icon @endif"></i></a>
                        </li>
                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <form id="report_favourite_form" method="POST" action="/report/add-favourite" style="display:none;">
            @csrf
            <input type="text" name="report_slug" value="" id="report_slug_input">
          </form>
          @endsection
          
          @section('help-links')
          @include('help.help-links',['helpLink'=>config('help-links.help_links.manage_reports'),'helpTitle'=>config('help-links.help_titles.manage_reports')])
          @endsection
          
          @section('after_scripts')
          <script src="/js/reports.js"></script>
          @stop