@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Reports Generator'])
@include('file-exports.partials.file-exports-submenu',['report_type' => 'generator_report'])

<div class="wrapper-content">

	<div class="container-fluid">

		@include('partials.success')
		@include('partials.error-message')
		@include('settings.partials.success-message')
		@include('settings.partials.delete-message')

		@include('reports.partials.saved-searchs')

		@include('reports.partials.filters')
		@include('partials.sync-messages')


		<div class="ibox">

			<div class="ibox-title">

				<div class="ibox-tools">

					<a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
					@include('reports.partials.share_via_email_button')
				</div>


			</div>

			<div class="ibox-content">

				<div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

				<div id="saved-search-success"></div>
				<div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
				</div>

				<table class="footable table table-stripped table-hover nowrap three-col-fixed has-column-toggler" data-page-length="50" data-searching="false"
					data-ordering="false">

					<thead>
						<tr>
							<th>#</th>
							<th>Asset Tag #</th>
							<th>Serial #</th>
							<th class="sort-alpha">Asset Type</th>
							<th>Manufacturer</th>
							<th>Child Asset</th>
							<th>Hardware Standard</th>
							<th>Technical Specs</th>
							<th>PO #</th>
							<th>Vendor</th>
							<th>Asset Status </i></th>
							<th>Lock Status</th>
							<th>User/Location</i></th>
							<th>Email</th>
							<th>Employee ID</th>
							<th>Business Title</th>
							<th>Department</th>
							<th>Work Location</th>
							<th>Legal Hold</th>
							<th>Hire Date</th>
							<th>Terminated Date</th>
							<th>Status</th>
							<th>Lease End Date </th>
							<th>Expected Return Date </th>
							<th>Mobile Carrier </th>
							<th>ITAD Certificate</th>
							<th>Asset Age </th>
							<th>Asset Value</th>
							<th>Depreciation Value </th>
							<th>Warranty End Date</th>
							<th>Last Modified Date </th>
							<th>Last Modified By </th>
						</tr>
					</thead>
				</table>
			</div>

		</div>


	</div>
</div>
@include('reports.modals.share_via_email')
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.report_generator'),'helpTitle'=>config('help-links.help_titles.report_generator')])
@endsection

@section('after_scripts')
@include('reports.scripts.filter-options-with-ajax')
@include('reports.scripts.generator')
@include('reports.scripts.datatable-column-toggle-script')
@include('reports.scripts.share_via_email',['storageFileCreateUrl' => '/report/generator-export-create/1','formID' =>
'#asset-filter-form'])

<script src="/js/report-asset-filter.js"></script>
@stop

