@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Reports Generator Guide', 'parentUrl' => route('reports-generator'), 'parentTitle' => 'Report Generator'])

<div class="wrapper-content">

	<div class="container-fluid">

		<div class="row">

			<div class="col-lg-12">

				<div class="ibox">

					<div class="ibox-content">

						<div class="alert alert-warning">

							<strong>IMPORTANT NOTE:</strong> All reports have the ability to add or remove desired attributes.  You can access additional options by populating more fields with desired values.  The export will include all values plus attributes.

						</div>

						<div class="row">

							<div class="col-lg-2">

								<div class="list-group">

									<a href="#rh1" class="list-group-item">Asset Creation Report</a>

									<a href="#rh2" class="list-group-item">Asset Activity and Modified/Updated Report</a>

									<a href="#rh3" class="list-group-item">Asset Report</a>

									<a href="#rh4" class="list-group-item">Leased Asset Report</a>

									<a href="#rh5" class="list-group-item">User or Location Usage Report</a>

									<a href="#rh6" class="list-group-item">Depreciation Report</a>

									<a href="#rh7" class="list-group-item">Asset Age Report</a>

									<a href="#rh8" class="list-group-item">PO Asset Detail Report</a>

									<a href="#rh9" class="list-group-item">Inventory Report</a>

									<a href="#rh10" class="list-group-item">Inventory Variance Report</a>

									<a href="#rh11" class="list-group-item">Active or Inactive Location or People report</a>

									<a href="#rh12" class="list-group-item">Projection Report</a>

								</div>

							</div>

							<div class="col-lg-10">

								<h2>Date Specific Reports</h2>

								<p>These reports provide data on specific date ranges and activities within those date ranges.</p>



								<div class="well" id="rh1">

									<h3>Asset Creation Report</h3>

									<p>This report will list assets added during a specified date range.</p>



									<img src="/img/report-help-1.png" alt="" class="img-responsive">

								</div>



								<div class="well" id="rh2">

									<h3>Asset Activity and Modified/Updated Report</h3>



									<ul>

										<li>Assigned</li>

										<li>In Transit</li>

										<li>Damaged</li>

										<li>Repaired</li>

										<li>End of Life</li>

										<li>Disposed</li>

									</ul>



									<p>This report will list assets updated during a specific date range. This report can also show asset in transit activity including the in transit length in time during a specific date range.  Next, this report also shows assets that were damaged and repaired or not repaired in a date range. Last but not least, this report can also show assets that are end of life or were disposed during a specific disposal date range. All you have to do is selected the desired statuses and asset types along with the Updated At Range:</p>



									<img src="/img/report-help-2.png" alt="" class="img-responsive">

								</div>



								<h2>Allotment Reports</h2>

								<p>These reports provide data on the whereabouts of assets.</p>



								<div class="well" id="rh3">

									<h3>Asset Report</h3>



									<p>This report can be used to reconcile asset information within any status, location, or assignment to a location or person. Additionally, you can combine this report with any date ranges to narrow down your search to a more granular one. This report can also be utilized to review the type of assets that are assigned within your environment to help plan support mechanisms.</p>



									<img src="/img/report-help-3.png" alt="" class="img-responsive">

								</div>



								<div class="well" id="rh4">

									<h3>Leased Asset Report</h3>



									<p>This report can be used to reconcile leased asset information. This report can help plan for lease returns, renewals, and proactive planning with newer replacement devices. by book.</p>



									<img src="/img/report-help-4.png" alt="" class="img-responsive">

								</div>



								<div class="well" id="rh5">

									<h3>Person or Location Usage Report</h3>



									<p>This report can be used to review all assets assigned to specific people or locations. You can also preview reports deployed to specific departments, geographical location or type of locations.</p>



									<img src="/img/report-help-5.png" alt="" class="img-responsive">

								</div>



								<h2>Financial Reports</h2>

								<p>These reports provide data which can be used for financial planning.</p>



								<div class="well" id="rh6">

									<h3>Depreciation Report</h3>



									<p>This report can be used to generate depreciation value report for past, current, or future periods.</p>



									<img src="/img/report-help-6.png" alt="" class="img-responsive">

								</div>



								<div class="well" id="rh7">

									<h3>Asset Age Report</h3>

									<p>This report can be used to generate asset age report to review older asset liability, plan for upgrades in the current period and know what the future periods look like.</p>



									<img src="/img/report-help-7.png" alt="" class="img-responsive">

								</div>



								<h2>Additional Reports</h2>

								

								<div class="well" id="rh8">

									<h3>PO Asset Detail Report</h3>



									<p>This report can be used to view information on assets by their PO Details. This will help you review purchase date, received date, device cost and number of devices ordered per PO.</p>

									<img src="/img/report-help-8.png" alt="" class="img-responsive">

								</div>



								<div class="well" id="rh9">

									<h3>Inventory Report</h3>



									<p>This report can be used as a checklist for a physical inventory count at any of your warehouse location(s). Use this to assess against your demand to plan your purchases</p>

									<img src="/img/report-help-9.png" alt="" class="img-responsive">

								</div>



								<div class="well" id="rh10">

									<h3>Inventory Variance Report</h3>



									<p>This report can be used to create a comparison report between a physical inventory scan using a handheld scanner and the virtual asset data in the Asset Management system's database. The report will calculate a variance analysis indicating which assets match and which asset do not match. You will also see reasons of why there are mismatches.</p>



									<img src="/img/report-help-10.png" alt="" class="img-responsive">

								</div>

								<div class="well" id="rh11">

									<h3>Active or Inactive Location or People report</h3>



									<p>This report can be used to review the locations or people that possess asset needed collection due to the location or people being changed to inactive</p>

									<img src="/img/report-help-11.png" alt="" class="img-responsive">

								</div>

								<div class="well" id="rh12">

									<h3>Projection Report</h3>



									<p>This report can generated after one quarter's usage unless there is adequate past data to ingest into the system.</p>

								</div>

							</div>

						</div>

					</div>

				</div>

			</div>

		</div>

	</div>

@stop