@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Fleet Age Report', 'parentUrl' => '#', 'parentTitle' =>
'Inventory Control'])
<div class="wrapper-content">

    <div class="container-fluid">

        <div class="row">

            <div class="col-lg-3">
                <div class="ibox">
                    <div class="ibox-content">
                        <form action="{{route('fleet-age-search')}}" method="post" id="fleet-age-report">
                            {{csrf_field()}}

                            <div class="form-group">
                                <label class="control-label">Asset Type</label>
                                <select name="selected_asset_type" class="form-control select2" id="asset_type_id">
                                    <option value="">All</option>
                                    @foreach($filterDataOptions['assetTypesAll'] as $assetType)
                                    <option value="{{$assetType->id}}" @if(request('selected_asset_type')==$assetType->
                                        id) selected="selected" @endif>{{$assetType->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="control-label">Asset Status</label>
                                <select name="selected_status" class="form-control select2" id="selected-status">
                                    <option value="">All</option>
                                    @foreach($filterDataOptions['statuses'] as $status)
                                    <option value="{{$status->slug}}" @if(request('selected_status')==$status->slug)
                                        selected="selected" @endif>{{$status->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="control-label">Hardware Standard</label>
                                <select name="selected_standard" class="form-control select2" id="make_and_model_id">
                                    <option value="">All</option>
                                    @foreach($filterDataOptions['hardwareStandards'] as $hardwareStandard)
                                    <option value="{{$hardwareStandard->id}}"
                                        @if(request('selected_standard')==$hardwareStandard->id) selected="selected"
                                        @endif>{{$hardwareStandard->makeModelName}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="control-label">Employee Status</label>
                                <select name="selected_employee_status" class="form-control select2"
                                    id="selected-employee-status">
                                    <option value="">All</option>
                                    <option value="1" @if(request('selected_employee_status')==1) selected="selected"
                                        @endif>Active</option>
                                    <option value="2" @if(request('selected_employee_status')==2) selected="selected"
                                        @endif>Inactive</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="control-label">Employee Type</label>
                                <select name="selected_employee_type" class="form-control select2"
                                    id="selected-employee-type">
                                    <option value="">All</option>
                                    @foreach($filterDataOptions['employeeTypes'] as $employeeType)
                                    <option value="{{$employeeType->slug}}"
                                        @if(request('selected_employee_type')==$employeeType->slug) selected="selected"
                                        @endif>{{$employeeType->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="control-label">Region</label>
                                <select name="selected_region" class="form-control select2" id="selected-region">
                                    <option value="">All</option>
                                    @foreach($filterDataOptions['regions'] as $region)
                                    <option value="{{$region->id}}" @if(request('selected_region')==$region->id)
                                        selected="selected" @endif>{{$region->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="control-label">Location</label>
                                <select name="selected_location" class="form-control select2" id="selected-location">
                                    <option value="">All</option>
                                    @foreach($filterDataOptions['locations'] as $location)
                                    <option value="{{$location->id}}" @if(request('selected_location')==$location->id)
                                        selected="selected" @endif>{{$location->room_name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="control-label">Department</label>
                                <select name="selected_department" class="form-control select2"
                                    id="selected-department">
                                    <option value="">All</option>
                                    @foreach($filterDataOptions['departments'] as $department)
                                    <option value="{{$department->id}}"
                                        @if(request('selected_department')==$department->id) selected="selected"
                                        @endif>{{$department->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="control-label">Asset Age</label>
                                <select name="selected_age" class="form-control select2" id="selected-age">
                                    <option value="1" @if(request('selected_age')=="1" ) selected="selected" @endif>1
                                        Years</option>
                                    <option value="2" @if(request('selected_age')=="2" || !request('selected_age'))
                                        selected="selected" @endif>2 Years</option>
                                    <option value="3" @if(request('selected_age')=="3" ) selected="selected" @endif>3
                                        Years</option>
                                    <option value="4" @if(request('selected_age')=="4" ) selected="selected" @endif>4
                                        Years</option>
                                </select>
                            </div>

                            <div class="form-group m-t-md">
                                <button type="submit" class="btn btn-primary">Search</button>
                            </div>

                        </form>
                    </div>
                </div>

            </div>

            @include('partials.success')
            @include('partials.error-message')
            <div class="col-lg-9">

                <div class="ibox">

                    <div class="ibox-title">
                        <h5>Asset EOL (Creation Date Plus {{request('selected_age') ? request('selected_age') : 2}}
                            years) by Month</h5>
                    </div>

                    <div class="ibox-content">

                        <canvas id="barChart" height="140"></canvas>
                        <button class="btn btn-primary save-chart-btn" data-name="Asset EOL (Creation Date Plus {{request('selected_age') ? request('selected_age') : 2}} years) by Month" data-sheettitle="Fleet Age" data-slug="Fleet-Age" data-filename="fleet-age">Save
                            to Excel</button>

                    </div>

                </div>
            </div>

        </div>

    </div>

</div>

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.fleet_age'),'helpTitle'=>config('help-links.help_titles.fleet_age')])
@endsection

@section('after_scripts')
@include('reports.script-includes.chartJs')
@include('reports.fleet-age.scripts.script')
@stop